/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1QueuingConfiguration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LimitResponse defines how to handle requests that can not be executed right now.")
public class V1LimitResponse {
    public static final String SERIALIZED_NAME_QUEUING = "queuing";
    @SerializedName(value="queuing")
    @Nullable
    private V1QueuingConfiguration queuing;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LimitResponse queuing(@Nullable V1QueuingConfiguration queuing) {
        this.queuing = queuing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1QueuingConfiguration getQueuing() {
        return this.queuing;
    }

    public void setQueuing(@Nullable V1QueuingConfiguration queuing) {
        this.queuing = queuing;
    }

    public V1LimitResponse type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`type` is \"Queue\" or \"Reject\". \"Queue\" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. \"Reject\" means that requests that can not be executed upon arrival are rejected. Required.")
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitResponse v1LimitResponse = (V1LimitResponse)o;
        return Objects.equals(this.queuing, v1LimitResponse.queuing) && Objects.equals(this.type, v1LimitResponse.type);
    }

    public int hashCode() {
        return Objects.hash(this.queuing, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LimitResponse {\n");
        sb.append("    queuing: ").append(this.toIndentedString(this.queuing)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LimitResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LimitResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_QUEUING) != null && !jsonObj.get(SERIALIZED_NAME_QUEUING).isJsonNull()) {
            V1QueuingConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_QUEUING));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V1LimitResponse fromJson(String jsonString) throws IOException {
        return (V1LimitResponse)JSON.getGson().fromJson(jsonString, V1LimitResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUEUING);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LimitResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LimitResponse.class));
            return new TypeAdapter<V1LimitResponse>(){

                public void write(JsonWriter out, V1LimitResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LimitResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LimitResponse.validateJsonElement(jsonElement);
                    return (V1LimitResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

