/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.util.Strings;
import io.kubernetes.client.util.generic.options.PatchOptions;

public class KubectlApply<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlApply<ApiType>>
implements Kubectl.Executable<ApiType> {
    private ApiType targetObj;
    private String fieldManager = "kubernetes-java-kubectl-apply";
    private boolean forceConflict = false;
    public static final String DEFAULT_FIELD_MANAGER = "kubernetes-java-kubectl-apply";

    KubectlApply(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlApply<ApiType> fieldManager(String fieldManager) {
        this.fieldManager = fieldManager;
        return this;
    }

    public KubectlApply<ApiType> forceConflict(boolean isForceConflict) {
        this.forceConflict = isForceConflict;
        return this;
    }

    public KubectlApply<ApiType> resource(ApiType obj) {
        this.targetObj = obj;
        return this;
    }

    private void validate() throws KubectlException {
        if (Strings.isNullOrEmpty((String)this.fieldManager)) {
            throw new KubectlException("Field-manager must not be empty for server-side-apply");
        }
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.validate();
        return this.executeServerSideApply();
    }

    private ApiType executeServerSideApply() throws KubectlException {
        this.refreshDiscovery();
        Object api = this.getGenericApi((KubernetesObject)this.targetObj);
        if (api == null) {
            api = this.getGenericApi();
        }
        PatchOptions patchOptions = new PatchOptions();
        patchOptions.setForce(Boolean.valueOf(this.forceConflict));
        patchOptions.setFieldManager(this.fieldManager);
        if (this.isNamespaced((KubernetesObject)this.targetObj)) {
            String targetNamespace = this.namespace != null ? this.namespace : (Strings.isNullOrEmpty((String)this.targetObj.getMetadata().getNamespace()) ? "default" : this.targetObj.getMetadata().getNamespace());
            Object response = null;
            try {
                String string = this.targetObj.getMetadata().getName();
                this.apiClient.getJSON();
                return (ApiType)((KubernetesObject)api.patch(targetNamespace, string, "application/apply-patch+yaml", new V1Patch(JSON.serialize(this.targetObj)), patchOptions).throwsApiException().getObject());
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
        try {
            String string = this.targetObj.getMetadata().getName();
            this.apiClient.getJSON();
            return (ApiType)((KubernetesObject)api.patch(string, "application/apply-patch+yaml", new V1Patch(JSON.serialize(this.targetObj)), patchOptions).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }
}

