/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl.util.deployment;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicaSetList;
import io.kubernetes.client.util.Yaml;
import io.kubernetes.client.util.labels.LabelSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeploymentHelper {
    public static final String DEFAULT_DEPLOYMENT_UNIQUE_LABEL_KEY = "pod-template-hash";
    public static final String REVISION_ANNOTATION = "deployment.kubernetes.io/revision";

    public static V1ReplicaSet getAllReplicaSets(V1Deployment deployment, AppsV1Api api, List<V1ReplicaSet> oldRSes, List<V1ReplicaSet> allOldRSes) throws ApiException {
        List<V1ReplicaSet> rsList = DeploymentHelper.listReplicaSets(deployment, api);
        V1ReplicaSet newRs = DeploymentHelper.findNewReplicaSet(deployment, rsList);
        DeploymentHelper.findOldReplicaSets(rsList, newRs, oldRSes, allOldRSes);
        return newRs;
    }

    public static Long revision(V1ObjectMeta meta) {
        if (meta.getAnnotations() == null) {
            return 0L;
        }
        String v = (String)meta.getAnnotations().get(REVISION_ANNOTATION);
        return v == null ? 0L : Long.parseLong(v);
    }

    private static List<V1ReplicaSet> listReplicaSets(V1Deployment deployment, AppsV1Api api) throws ApiException {
        String namespace = deployment.getMetadata().getNamespace();
        LabelSelector selector = LabelSelector.parse((V1LabelSelector)deployment.getSpec().getSelector());
        List<V1ReplicaSet> all = DeploymentHelper.rsListFromClient(namespace, selector.toString(), api);
        ArrayList<V1ReplicaSet> owned = new ArrayList<V1ReplicaSet>(all.size());
        for (V1ReplicaSet rs : all) {
            List refs = rs.getMetadata().getOwnerReferences();
            Optional<V1OwnerReference> ref = refs.stream().filter(o -> o.getController() != null && o.getController() != false).findAny();
            if (!ref.isPresent() || !ref.get().getUid().equals(deployment.getMetadata().getUid())) continue;
            owned.add(rs);
        }
        return owned;
    }

    private static List<V1ReplicaSet> rsListFromClient(String namespace, String selector, AppsV1Api api) throws ApiException {
        V1ReplicaSetList rsList = api.listNamespacedReplicaSet(namespace).labelSelector(selector).execute();
        return rsList.getItems();
    }

    private static V1ReplicaSet findNewReplicaSet(V1Deployment deployment, List<V1ReplicaSet> rsList) {
        rsList.sort((o1, o2) -> {
            if (o1.getMetadata().getCreationTimestamp().equals(o2.getMetadata().getCreationTimestamp())) {
                return o1.getMetadata().getName().compareTo(o2.getMetadata().getName());
            }
            if (o1.getMetadata().getCreationTimestamp().isBefore(o2.getMetadata().getCreationTimestamp())) {
                return -1;
            }
            return 1;
        });
        for (V1ReplicaSet rs : rsList) {
            if (!DeploymentHelper.equalIgnoreHash(rs.getSpec().getTemplate(), deployment.getSpec().getTemplate())) continue;
            return rs;
        }
        return null;
    }

    private static boolean equalIgnoreHash(V1PodTemplateSpec template1, V1PodTemplateSpec template2) {
        if (!Objects.equals(template1.getSpec(), template2.getSpec())) {
            return false;
        }
        V1ObjectMeta m1Copy = DeploymentHelper.objectMetaDeepCopy(template1.getMetadata());
        V1ObjectMeta m2Copy = DeploymentHelper.objectMetaDeepCopy(template2.getMetadata());
        m1Copy.getLabels().remove(DEFAULT_DEPLOYMENT_UNIQUE_LABEL_KEY);
        m2Copy.getLabels().remove(DEFAULT_DEPLOYMENT_UNIQUE_LABEL_KEY);
        return m1Copy.equals((Object)m2Copy);
    }

    private static void findOldReplicaSets(List<V1ReplicaSet> rsList, V1ReplicaSet newRs, List<V1ReplicaSet> oldRSes, List<V1ReplicaSet> allOldRSes) {
        for (V1ReplicaSet rs : rsList) {
            if (newRs != null && rs.getMetadata().getUid().equals(newRs.getMetadata().getUid())) continue;
            allOldRSes.add(rs);
            if (rs.getSpec().getReplicas().equals(0)) continue;
            oldRSes.add(rs);
        }
    }

    private static V1ObjectMeta objectMetaDeepCopy(V1ObjectMeta meta) {
        String data = Yaml.dump((Object)meta);
        return (V1ObjectMeta)Yaml.loadAs((String)data, V1ObjectMeta.class);
    }
}

