/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteNamingConvention
implements NamingConvention {
    private static final Pattern PATTERN_NAME_BLACKLISTED_CHARS = Pattern.compile("[{}(),=\\[\\]/ ?:]");
    private static final Pattern PATTERN_TAG_BLACKLISTED_CHARS = Pattern.compile("[{}(),=\\[\\]/ ?:.]");
    private final NamingConvention delegate;

    public GraphiteNamingConvention() {
        this(NamingConvention.camelCase);
    }

    public GraphiteNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.sanitizeName(this.delegate.name(this.normalize(name), type, baseUnit));
    }

    public String tagKey(String key) {
        return this.sanitizeTag(this.delegate.tagKey(this.normalize(key)));
    }

    public String tagValue(String value) {
        return this.sanitizeTag(this.delegate.tagValue(this.normalize(value)));
    }

    private String normalize(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFKD);
    }

    private String sanitizeName(String delegated) {
        return PATTERN_NAME_BLACKLISTED_CHARS.matcher(delegated).replaceAll("_");
    }

    private String sanitizeTag(String delegated) {
        return PATTERN_TAG_BLACKLISTED_CHARS.matcher(delegated).replaceAll("_");
    }
}

