/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.DClass;
import io.milton.dns.record.RRSIGRecord;
import io.milton.dns.record.Record;
import io.milton.dns.record.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RRset
implements Serializable {
    private static final long serialVersionUID = -3270249290171239695L;
    private List rrs;
    private short nsigs;
    private short position;

    public RRset() {
        this.rrs = new ArrayList(1);
        this.nsigs = 0;
        this.position = 0;
    }

    public RRset(Record record) {
        this();
        this.safeAddRR(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RRset(RRset rrset) {
        RRset rRset = rrset;
        synchronized (rRset) {
            this.rrs = (List)((ArrayList)rrset.rrs).clone();
            this.nsigs = rrset.nsigs;
            this.position = rrset.position;
        }
    }

    private void safeAddRR(Record r) {
        if (!(r instanceof RRSIGRecord)) {
            if (this.nsigs == 0) {
                this.rrs.add(r);
            } else {
                this.rrs.add(this.rrs.size() - this.nsigs, r);
            }
        } else {
            this.rrs.add(r);
            this.nsigs = (short)(this.nsigs + 1);
        }
    }

    public synchronized void addRR(Record r) {
        if (this.rrs.isEmpty()) {
            this.safeAddRR(r);
            return;
        }
        Record first = this.first();
        if (!r.sameRRset(first)) {
            throw new IllegalArgumentException("record does not match rrset");
        }
        if (r.getTTL() != first.getTTL()) {
            if (r.getTTL() > first.getTTL()) {
                r = r.cloneRecord();
                r.setTTL(first.getTTL());
            } else {
                for (int i = 0; i < this.rrs.size(); ++i) {
                    Record tmp = (Record)this.rrs.get(i);
                    tmp = tmp.cloneRecord();
                    tmp.setTTL(r.getTTL());
                    this.rrs.set(i, tmp);
                }
            }
        }
        if (!this.rrs.contains(r)) {
            this.safeAddRR(r);
        }
    }

    public synchronized void deleteRR(Record r) {
        if (this.rrs.remove(r) && r instanceof RRSIGRecord) {
            this.nsigs = (short)(this.nsigs - 1);
        }
    }

    public synchronized void clear() {
        this.rrs.clear();
        this.position = 0;
        this.nsigs = 0;
    }

    private synchronized Iterator iterator(boolean data, boolean cycle) {
        int start;
        int total = this.rrs.size();
        int size = data ? total - this.nsigs : this.nsigs;
        if (size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (data) {
            if (!cycle) {
                start = 0;
            } else {
                if (this.position >= size) {
                    this.position = 0;
                }
                short s = this.position;
                this.position = (short)(s + 1);
                start = s;
            }
        } else {
            start = total - this.nsigs;
        }
        ArrayList list = new ArrayList(size);
        if (data) {
            list.addAll(this.rrs.subList(start, size));
            if (start != 0) {
                list.addAll(this.rrs.subList(0, start));
            }
        } else {
            list.addAll(this.rrs.subList(start, total));
        }
        return list.iterator();
    }

    public synchronized Iterator rrs(boolean cycle) {
        return this.iterator(true, cycle);
    }

    public synchronized Iterator rrs() {
        return this.iterator(true, true);
    }

    public synchronized Iterator sigs() {
        return this.iterator(false, false);
    }

    public synchronized int size() {
        return this.rrs.size() - this.nsigs;
    }

    public Name getName() {
        return this.first().getName();
    }

    public int getType() {
        return this.first().getRRsetType();
    }

    public int getDClass() {
        return this.first().getDClass();
    }

    public synchronized long getTTL() {
        return this.first().getTTL();
    }

    public synchronized Record first() {
        if (this.rrs.isEmpty()) {
            throw new IllegalStateException("rrset is empty");
        }
        return (Record)this.rrs.get(0);
    }

    private String iteratorToString(Iterator it) {
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Record rr = (Record)it.next();
            sb.append("[");
            sb.append(rr.rdataToString());
            sb.append("]");
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.rrs == null) {
            return "{empty}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.getName()).append(" ");
        sb.append(this.getTTL()).append(" ");
        sb.append(DClass.string(this.getDClass())).append(" ");
        sb.append(Type.string(this.getType())).append(" ");
        sb.append(this.iteratorToString(this.iterator(true, false)));
        if (this.nsigs > 0) {
            sb.append(" sigs: ");
            sb.append(this.iteratorToString(this.iterator(false, false)));
        }
        sb.append(" }");
        return sb.toString();
    }
}

