/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.record.Message;
import io.milton.dns.record.Resolver;
import io.milton.dns.record.ResolverListener;

class ResolveThread
extends Thread {
    private final Message query;
    private final Object id;
    private final ResolverListener listener;
    private final Resolver res;

    public ResolveThread(Resolver res, Message query, Object id, ResolverListener listener) {
        this.res = res;
        this.query = query;
        this.id = id;
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            Message response = this.res.send(this.query);
            this.listener.receiveMessage(this.id, response);
        }
        catch (Exception e) {
            this.listener.handleException(this.id, e);
        }
    }
}

