/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.common.Path;
import io.milton.common.Service;
import io.milton.ftp.FtpActionListener;
import io.milton.ftp.MiltonFsView;
import io.milton.ftp.MiltonFtpHandler;
import io.milton.ftp.MiltonListenerFactory;
import io.milton.ftp.MiltonUser;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpHandler;
import org.apache.ftpserver.impl.FtpHandler;
import org.apache.ftpserver.listener.ListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonFtpAdapter
implements FileSystemFactory,
Service {
    private static final Logger log = LoggerFactory.getLogger(MiltonFtpAdapter.class);
    private final ResourceFactory resourceFactory;
    private final FtpServer server;

    public MiltonFtpAdapter(ResourceFactory resourceFactory, FtpServer server) {
        this.resourceFactory = resourceFactory;
        this.server = server;
    }

    public MiltonFtpAdapter(ResourceFactory wrapped, UserManager userManager) throws FtpException {
        this(wrapped, userManager, null);
    }

    public MiltonFtpAdapter(ResourceFactory wrapped, UserManager userManager, FtpActionListener actionListener) throws FtpException {
        this(wrapped, userManager, actionListener, 21, true);
    }

    public MiltonFtpAdapter(ResourceFactory wrapped, UserManager userManager, int port) throws FtpException {
        this(wrapped, userManager, null, port, true);
    }

    public MiltonFtpAdapter(ResourceFactory wrapped, UserManager userManager, FtpActionListener actionListener, int port, boolean autoStart) throws FtpException {
        ListenerFactory factory;
        log.debug("creating FTP adapter on port: " + port);
        this.resourceFactory = wrapped;
        FtpServerFactory serverFactory = new FtpServerFactory();
        if (actionListener != null) {
            log.debug("using customised milton listener factory");
            MiltonFtpHandler ftpHandler = new MiltonFtpHandler((FtpHandler)new DefaultFtpHandler(), actionListener);
            factory = new MiltonListenerFactory(ftpHandler);
        } else {
            factory = new ListenerFactory();
        }
        factory.setPort(port);
        serverFactory.addListener("default", factory.createListener());
        serverFactory.setFileSystem((FileSystemFactory)this);
        serverFactory.setUserManager(userManager);
        this.server = serverFactory.createServer();
        if (autoStart) {
            this.start();
        } else {
            log.info("autoStart is false, so not starting FTP server just yet..");
        }
    }

    public void close() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public Resource getResource(Path path, String host) throws NotAuthorizedException, BadRequestException {
        return this.resourceFactory.getResource(host, path.toString());
    }

    public FileSystemView createFileSystemView(User user) throws FtpException {
        MiltonUser mu = (MiltonUser)user;
        try {
            Resource root = this.resourceFactory.getResource(mu.domain, "/");
        }
        catch (NotAuthorizedException ex) {
            throw new FtpException((Throwable)ex);
        }
        catch (BadRequestException ex) {
            throw new FtpException((Throwable)ex);
        }
        return new MiltonFsView(Path.root, mu.domain, this.resourceFactory, (MiltonUser)user);
    }

    public void start() {
        log.debug("starting the FTP server on port");
        try {
            this.server.start();
        }
        catch (FtpException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        this.server.stop();
    }
}

