/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

import io.milton.ftp.MiltonUser;
import io.milton.ftp.NameAndAuthority;
import io.milton.ftp.UserService;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerAdapter
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerAdapter.class);
    private final ResourceFactory resourceFactory;
    private final UserService userService;

    public UserManagerAdapter(ResourceFactory resourceFactory, UserService userLocator) {
        this.resourceFactory = resourceFactory;
        this.userService = userLocator;
    }

    public MiltonUser getUserByName(String fqn) throws FtpException {
        NameAndAuthority naa = NameAndAuthority.parse(fqn);
        if (naa.domain == null) {
            log.warn("invalid login. no domain specified. use form: user#domain");
            return null;
        }
        return this.userService.getUserByName(naa.toMilton(), naa.domain);
    }

    public String[] getAllUserNames() throws FtpException {
        return this.userService.getAllUserNames();
    }

    public void delete(String name) throws FtpException {
        this.userService.delete(name);
    }

    public void save(User user) throws FtpException {
        this.userService.save((MiltonUser)user);
    }

    public boolean doesExist(String name) throws FtpException {
        return this.userService.doesExist(name);
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            Resource hostRoot;
            UsernamePasswordAuthentication upa = (UsernamePasswordAuthentication)authentication;
            String user = upa.getUsername();
            String password = upa.getPassword();
            log.debug("authenticate: " + user);
            NameAndAuthority naa = NameAndAuthority.parse(user);
            if (naa.domain == null) {
                log.warn("invalid login. no domain specified. use form: user#domain");
                return null;
            }
            try {
                hostRoot = this.resourceFactory.getResource(naa.domain, "/");
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
            if (hostRoot == null) {
                log.warn("failed to find root for domain: " + naa.domain);
                return null;
            }
            Object oUser = hostRoot.authenticate(naa.toMilton(), password);
            if (oUser != null) {
                return new MiltonUser(oUser, naa.toMilton(), naa.domain);
            }
            log.debug("authentication failed: " + user);
            return null;
        }
        if (authentication instanceof AnonymousAuthentication) {
            log.debug("anonymous login not supported");
            return null;
        }
        log.warn("unknown authentication type: " + authentication.getClass());
        return null;
    }

    public String getAdminName() throws FtpException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAdmin(String arg0) throws FtpException {
        return false;
    }
}

