/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.SecurityManager;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlySecurityManager
implements SecurityManager {
    private final Logger log = LoggerFactory.getLogger(ReadOnlySecurityManager.class);
    private final String realm;

    public ReadOnlySecurityManager(String realm) {
        this.realm = realm;
    }

    public ReadOnlySecurityManager() {
        this.realm = null;
    }

    @Override
    public Object authenticate(String user, String password) {
        return "ok";
    }

    @Override
    public Object authenticate(DigestResponse digestRequest) {
        return digestRequest.getUser();
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth, Resource resource) {
        switch (method) {
            case GET: {
                return true;
            }
            case HEAD: {
                return true;
            }
            case OPTIONS: {
                return true;
            }
            case PROPFIND: {
                return true;
            }
        }
        this.log.debug("denying access to method {} on {}", (Object)method, (Object)request.getAbsolutePath());
        return false;
    }

    @Override
    public String getRealm(String host) {
        if (this.realm != null) {
            return this.realm;
        }
        if (host != null && host.length() > 0) {
            return host;
        }
        return "ReadOnlyRealm";
    }

    @Override
    public boolean isDigestAllowed() {
        return true;
    }
}

