/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlWriter {
    private Logger log = LoggerFactory.getLogger(XmlWriter.class);
    private boolean allowNewlines = false;
    protected final OutputStream out;
    protected final Charset charset;

    public static Charset utf8() {
        return Charset.forName("UTF-8");
    }

    public XmlWriter(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    public XmlWriter(OutputStream out) {
        this.out = out;
        this.charset = XmlWriter.utf8();
    }

    private void append(String value) {
        try {
            byte[] arr = value.getBytes(this.charset);
            this.out.write(arr);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void append(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeProperty(String namespace, String namespaceInfo, String name, String value) {
        this.writeElement(namespace, namespaceInfo, name, Type.OPENING);
        this.append(value);
        this.writeElement(namespace, namespaceInfo, name, Type.CLOSING);
    }

    public void writeProperty(String namespace, String name, String value) {
        if (value == null) {
            this.writeProperty(namespace, name);
        } else {
            this.writeElement(namespace, name, Type.OPENING);
            this.append(value);
            this.writeElement(namespace, name, Type.CLOSING);
        }
    }

    public void writeProperty(String namespace, String name) {
        this.writeElement(namespace, name, Type.NO_CONTENT);
    }

    public void writeProperty(String name) {
        this.writeElement(null, name, Type.NO_CONTENT);
    }

    public void writeElement(String namespace, String name, Type type) {
        this.writeElement(namespace, null, name, type);
    }

    public void open(String namespace, String name) {
        this.writeElement(namespace, name, Type.OPENING);
    }

    public void close(String namespace, String name) {
        this.writeElement(namespace, name, Type.CLOSING);
    }

    public void open(String name) {
        this.writeElement(null, name, Type.OPENING);
    }

    public void close(String name) {
        this.writeElement(null, name, Type.CLOSING);
    }

    public Element begin(String name) {
        Element el = new Element(null, name);
        return el;
    }

    public Element begin(String nsPrefix, String name) {
        Element el = new Element(null, nsPrefix, name);
        return el;
    }

    public void writeElement(String nsPrefix, String nsUrl, String name, Type type) {
        if (nsPrefix != null && nsPrefix.length() > 0) {
            switch (type) {
                case OPENING: {
                    if (nsUrl != null) {
                        this.append("<" + nsPrefix + ":" + name + " xmlns:" + nsPrefix + "=\"" + nsUrl + "\">");
                        break;
                    }
                    this.append("<" + nsPrefix + ":" + name + ">");
                    break;
                }
                case CLOSING: {
                    this.append("</" + nsPrefix + ":" + name + ">");
                    this.newLine();
                    break;
                }
                default: {
                    if (nsUrl != null) {
                        this.append("<" + nsPrefix + ":" + name + " xmlns:" + nsPrefix + "=\"" + nsUrl + "\"/>");
                        break;
                    }
                    this.append("<" + nsPrefix + ":" + name + "/>");
                    break;
                }
            }
        } else {
            switch (type) {
                case OPENING: {
                    this.append("<" + name + ">");
                    break;
                }
                case CLOSING: {
                    this.append("</" + name + ">\n");
                    break;
                }
                default: {
                    this.append("<" + name + "/>");
                }
            }
        }
    }

    public void writeText(String text) {
        this.append(text);
    }

    public void writeData(String data) {
        this.append("<![CDATA[" + data + "]]>");
    }

    public void writeXMLHeader() {
        this.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void newLine() {
        if (this.allowNewlines) {
            this.append("\n");
        }
    }

    public boolean isAllowNewlines() {
        return this.allowNewlines;
    }

    public void setAllowNewlines(boolean allowNewlines) {
        this.allowNewlines = allowNewlines;
    }

    public class Element {
        private final Element parent;
        private final String nsPrefix;
        private final String name;
        private boolean openEnded;

        Element(Element parent, String name) {
            this(parent, null, name);
        }

        Element(Element parent, String nsPrefix, String name) {
            this.parent = parent;
            this.name = name;
            this.nsPrefix = nsPrefix;
            XmlWriter.this.append("<");
            if (nsPrefix != null) {
                XmlWriter.this.append(nsPrefix);
                XmlWriter.this.append(":");
            }
            XmlWriter.this.append(name);
        }

        Element(Element parent, String uri, String nsPrefix, String name) {
            this.parent = parent;
            this.name = name;
            this.nsPrefix = nsPrefix;
            XmlWriter.this.append("<");
            if (nsPrefix != null) {
                XmlWriter.this.append(nsPrefix);
                XmlWriter.this.append(":");
            }
            XmlWriter.this.append(name);
            XmlWriter.this.append(" ");
            XmlWriter.this.append("xmlns:" + nsPrefix + "=\"");
            XmlWriter.this.append(uri);
            XmlWriter.this.append("\"");
        }

        public Element writeAtt(String name, String value) {
            XmlWriter.this.append(" ");
            XmlWriter.this.append(name);
            XmlWriter.this.append("=");
            XmlWriter.this.append('\"');
            XmlWriter.this.append(value == null ? "" : value);
            XmlWriter.this.append('\"');
            return this;
        }

        public Element writeText(String text) {
            return this.writeText(text, true);
        }

        public Element writeText(String text, boolean newline) {
            if (!this.openEnded) {
                this.open(newline);
            }
            XmlWriter.this.append(text);
            return this;
        }

        public Element open() {
            return this.open(true);
        }

        public Element open(boolean newline) {
            this.openEnded = true;
            XmlWriter.this.append(">");
            if (newline) {
                XmlWriter.this.newLine();
            }
            return this;
        }

        public Element close() {
            return this.close(false);
        }

        public Element close(boolean newline) {
            if (this.openEnded) {
                if (this.nsPrefix != null) {
                    XmlWriter.this.append("</" + this.nsPrefix + ":" + this.name + ">");
                    XmlWriter.this.newLine();
                } else {
                    XmlWriter.this.append("</" + this.name + ">");
                    XmlWriter.this.newLine();
                }
                if (newline) {
                    XmlWriter.this.newLine();
                }
                return this.parent;
            }
            if (newline) {
                XmlWriter.this.newLine();
            }
            return this.noContent();
        }

        public Element noContent() {
            XmlWriter.this.append("/>");
            XmlWriter.this.newLine();
            return this.parent;
        }

        public Element noContent(boolean newLine) {
            XmlWriter.this.append("/>");
            if (newLine) {
                XmlWriter.this.newLine();
            }
            return this.parent;
        }

        public Element begin(String name) {
            return this.begin(null, name);
        }

        public Element begin(String prefix, String name) {
            return this.begin(prefix, name, true);
        }

        public Element begin(String prefix, String name, boolean newLine) {
            if (!this.openEnded) {
                this.open(newLine);
            }
            Element el = new Element(this, prefix, name);
            return el;
        }

        public Element begin(String uri, String prefix, String name) {
            if (!this.openEnded) {
                this.open();
            }
            Element el = new Element(this, uri, prefix, name);
            return el;
        }

        public Element prop(String name, String value) {
            this.begin(name).writeText(value, false).close(true);
            return this;
        }

        public Element prop(String name, Integer value) {
            if (value != null) {
                this.prop(name, value.toString());
            } else {
                this.begin(name).noContent();
            }
            return this;
        }
    }

    public static enum Type {
        OPENING,
        CLOSING,
        NO_CONTENT;

    }
}

