/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.CalendarDateRangeQuery;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCalendarResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.ICalResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarDateRangeQueryAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CalendarDateRangeQueryAnnotationHandler.class);

    public CalendarDateRangeQueryAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, CalendarDateRangeQuery.class, new Request.Method[0]);
    }

    public List<ICalResource> execute(AnnoCalendarResource parent, Date start, Date finish) throws NotAuthorizedException, BadRequestException {
        Object source = parent.getSource();
        try {
            ControllerMethod cm = this.getBestMethod(source.getClass());
            if (cm == null) {
                return null;
            }
            ArrayList<AnnoResource> result = new ArrayList<AnnoResource>();
            Object[] args = this.annoResourceFactory.buildInvokeArgs(parent, cm.method, start, finish);
            Object eventSources = this.invoke(cm, parent, args);
            this.annoResourceFactory.createAndAppend(result, eventSources, parent, cm);
            ArrayList<ICalResource> list = new ArrayList<ICalResource>();
            for (AnnoResource r : result) {
                if (!(r instanceof ICalResource)) continue;
                list.add((ICalResource)r);
            }
            return list;
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.getClass() + " - " + source.getClass(), e);
        }
    }
}

