/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.annotated.DataBinder;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullSafeDateTimeConverter
extends AbstractConverter {
    private static final Logger log = LoggerFactory.getLogger(NullSafeDateTimeConverter.class);
    private static final String PACKAGE = "io.milton.http.annotated.";
    private String[] patterns;
    private String displayPatterns;
    private Locale locale;
    private boolean useLocaleFormat;

    private static Logger log() {
        return log;
    }

    public NullSafeDateTimeConverter() {
    }

    public NullSafeDateTimeConverter(Object defaultValue) {
        super(defaultValue);
    }

    protected Object handleMissing(Class type) {
        return null;
    }

    protected Class getDefaultType() {
        return Date.class;
    }

    public TimeZone getTimeZone() {
        return DataBinder.getTimeZoneForRequest();
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        if (patterns != null && patterns.length > 1) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < patterns.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(patterns[i]);
            }
            this.displayPatterns = buffer.toString();
        }
        this.setUseLocaleFormat(true);
    }

    protected String convertToString(Object value) throws Throwable {
        String result;
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Calendar) {
            date = ((Calendar)value).getTime();
        } else if (value instanceof Long) {
            date = new Date((Long)value);
        }
        if (this.useLocaleFormat && date != null) {
            DateFormat format = this.patterns != null && this.patterns.length > 0 ? this.getFormat(this.patterns[0]) : this.getFormat(this.locale, this.timeZone());
            this.logFormat("Formatting", format);
            result = format.format(date);
            if (NullSafeDateTimeConverter.log().isDebugEnabled()) {
                NullSafeDateTimeConverter.log().debug("    Converted  to String using format '" + result + "'");
            }
        } else {
            result = value.toString();
            if (NullSafeDateTimeConverter.log().isDebugEnabled()) {
                NullSafeDateTimeConverter.log().debug("    Converted  to String using toString() '" + result + "'");
            }
        }
        return result;
    }

    protected Object convertToType(Class targetType, Object value) throws Exception {
        Class<?> sourceType = value.getClass();
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            long timeInMillis = timestamp.getTime() / 1000L * 1000L;
            return this.toDate(targetType, timeInMillis += (long)(timestamp.getNanos() / 1000000));
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this.toDate(targetType, date.getTime());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        if (value instanceof Long) {
            Long longObj = (Long)value;
            return this.toDate(targetType, longObj);
        }
        String stringValue = value.toString().trim();
        if (stringValue.length() == 0) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            Calendar calendar;
            if (this.patterns != null && this.patterns.length > 0) {
                calendar = this.parse(sourceType, targetType, stringValue);
            } else {
                DateFormat format = this.getFormat(this.locale, this.timeZone());
                calendar = this.parse(sourceType, targetType, stringValue, format);
            }
            if (Calendar.class.isAssignableFrom(targetType)) {
                return calendar;
            }
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        return this.toDate(targetType, stringValue);
    }

    private Object toDate(Class type, long value) {
        if (type.equals(Date.class)) {
            return new Date(value);
        }
        if (type.equals(java.sql.Date.class)) {
            return new java.sql.Date(value);
        }
        if (type.equals(Time.class)) {
            return new Time(value);
        }
        if (type.equals(Timestamp.class)) {
            return new Timestamp(value);
        }
        if (type.equals(Calendar.class)) {
            TimeZone timeZone = this.timeZone();
            Calendar calendar = this.locale == null && timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(timeZone) : (timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(timeZone, this.locale)));
            calendar.setTime(new Date(value));
            calendar.setLenient(false);
            return calendar;
        }
        String msg = this.toString(((Object)((Object)this)).getClass()) + " cannot handle conversion to '" + this.toString(type) + "'";
        if (NullSafeDateTimeConverter.log().isWarnEnabled()) {
            NullSafeDateTimeConverter.log().warn("    " + msg);
        }
        throw new ConversionException(msg);
    }

    private Object toDate(Class type, String value) {
        if (type.equals(java.sql.Date.class)) {
            try {
                return java.sql.Date.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type.equals(Time.class)) {
            try {
                return Time.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type.equals(Timestamp.class)) {
            try {
                return Timestamp.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        String msg = this.toString(((Object)((Object)this)).getClass()) + " does not support default String to '" + this.toString(type) + "' conversion.";
        if (NullSafeDateTimeConverter.log().isWarnEnabled()) {
            NullSafeDateTimeConverter.log().warn("    " + msg);
            NullSafeDateTimeConverter.log().warn("    (N.B. Re-configure Converter or use alternative implementation)");
        }
        throw new ConversionException(msg);
    }

    protected DateFormat getFormat(Locale locale, TimeZone timeZone) {
        DateFormat format = locale == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format;
    }

    private DateFormat getFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        TimeZone timeZone = this.timeZone();
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format;
    }

    private Calendar parse(Class sourceType, Class targetType, String value) throws Exception {
        Exception firstEx = null;
        for (String pattern : this.patterns) {
            try {
                DateFormat format = this.getFormat(pattern);
                Calendar calendar = this.parse(sourceType, targetType, value, format);
                return calendar;
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
            }
        }
        if (this.patterns.length > 1) {
            throw new ConversionException("Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "' using  patterns '" + this.displayPatterns + "'");
        }
        throw firstEx;
    }

    private Calendar parse(Class sourceType, Class targetType, String value, DateFormat format) {
        this.logFormat("Parsing", format);
        format.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date parsedDate = format.parse(value, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value.length() || parsedDate == null) {
            String msg = "Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format instanceof SimpleDateFormat) {
                msg = msg + " using pattern '" + ((SimpleDateFormat)format).toPattern() + "'";
            }
            if (NullSafeDateTimeConverter.log().isDebugEnabled()) {
                NullSafeDateTimeConverter.log().debug("    " + msg);
            }
            throw new ConversionException(msg);
        }
        Calendar calendar = format.getCalendar();
        return calendar;
    }

    public String toString() {
        TimeZone timeZone;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toString(((Object)((Object)this)).getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.displayPatterns != null) {
            buffer.append(", Patterns={");
            buffer.append(this.displayPatterns);
            buffer.append('}');
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        if ((timeZone = this.timeZone()) != null) {
            buffer.append(", TimeZone=");
            buffer.append(timeZone);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private void logFormat(String action, DateFormat format) {
        if (NullSafeDateTimeConverter.log().isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder(45);
            buffer.append("    ");
            buffer.append(action);
            buffer.append(" with Format");
            if (format instanceof SimpleDateFormat) {
                buffer.append("[");
                buffer.append(((SimpleDateFormat)format).toPattern());
                buffer.append("]");
            }
            buffer.append(" for ");
            if (this.locale == null) {
                buffer.append("default locale");
            } else {
                buffer.append("locale[");
                buffer.append(this.locale);
                buffer.append("]");
            }
            TimeZone timeZone = this.timeZone();
            if (timeZone != null) {
                buffer.append(", TimeZone[");
                buffer.append(timeZone);
                buffer.append("]");
            }
            NullSafeDateTimeConverter.log().debug(buffer.toString());
        }
    }

    private String toString(Class type) {
        String typeName;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }

    private TimeZone timeZone() {
        return DataBinder.getTimeZoneForRequest();
    }
}

