/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.entity;

import io.milton.http.Response;
import io.milton.http.entity.EntityTransport;
import io.milton.http.webdav.UserAgentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityTransport
implements EntityTransport {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityTransport.class);
    private UserAgentHelper userAgentHelper;

    public DefaultEntityTransport(UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
    }

    @Override
    public void sendResponseEntity(Response response) throws Exception {
        if (response.getEntity() != null) {
            response.getEntity().write(response, response.getOutputStream());
        } else {
            log.warn("No response entity to send!");
        }
    }

    @Override
    public void closeResponse(Response response) {
        response.close();
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }

    public void setUserAgentHelper(UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
    }
}

