/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.common.FileUtils;
import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.common.RandomFileOutputStream;
import io.milton.event.Event;
import io.milton.event.NewFolderEvent;
import io.milton.event.PutEvent;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialllyUpdateableResource;
import io.milton.http.http11.PutHelper;
import io.milton.http.quota.StorageChecker;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.CalendarResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.GetableResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.ReplaceableResource;
import io.milton.resource.Resource;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(PutHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final PutHelper putHelper;
    private final MatchHelper matchHelper;

    public PutHandler(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper, PutHelper putHelper, MatchHelper matchHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.putHelper = putHelper;
        this.matchHelper = matchHelper;
        this.checkResponseHandler();
    }

    private void checkResponseHandler() {
        if (!(this.responseHandler instanceof WebDavResponseHandler)) {
            log.warn("response handler is not a WebDavResponseHandler, so locking and quota checking will not be enabled");
        }
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.PUT.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof PutableResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException, NotFoundException {
        Resource parent;
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String urlToCreateOrUpdate = HttpManager.decodeUrl(request.getAbsolutePath());
        LogUtils.debug((Logger)log, (Object[])new Object[]{"PUT request. Host:", host, " Url:", urlToCreateOrUpdate, " content length header:", request.getContentLengthHeader()});
        Path path = Path.path((String)urlToCreateOrUpdate);
        urlToCreateOrUpdate = path.toString();
        Resource existingResource = manager.getResourceFactory().getResource(host, urlToCreateOrUpdate);
        StorageChecker.StorageErrorReason storageErr = null;
        if (existingResource != null) {
            if (!this.handlerHelper.checkAuthorisation(manager, existingResource, request)) {
                this.responseHandler.respondUnauthorised(existingResource, response, request);
                return;
            }
            if (this.handlerHelper.isLockedOut(request, existingResource)) {
                log.warn("resource is locked, but not by the current user");
                this.respondLocked(request, response, existingResource);
                return;
            }
            if (!this.matchHelper.checkIfMatch(existingResource, request)) {
                log.info("if-match comparison failed, aborting PUT request");
                this.responseHandler.respondPreconditionFailed(request, response, existingResource);
                return;
            }
            if (this.matchHelper.checkIfNoneMatch(existingResource, request)) {
                log.info("if-none-match comparison failed, aborting PUT request");
                this.responseHandler.respondPreconditionFailed(request, response, existingResource);
                return;
            }
            parent = manager.getResourceFactory().getResource(host, path.getParent().toString());
            if (parent instanceof CollectionResource) {
                CollectionResource parentCol = (CollectionResource)parent;
                storageErr = this.handlerHelper.checkStorageOnReplace(request, parentCol, existingResource, host);
            } else {
                log.warn("parent exists but is not a collection resource: " + path.getParent());
            }
        } else {
            if (!this.matchHelper.checkIfMatch(null, request)) {
                parent = manager.getResourceFactory().getResource(host, path.getParent().toString());
                if (parent instanceof CalendarResource) {
                    log.info("if-match comparison failed on null resource, but parent is a calendar, so allow to proceed");
                } else {
                    log.info("if-match comparison failed on null resource, aborting PUT request");
                    this.responseHandler.respondPreconditionFailed(request, response, existingResource);
                    return;
                }
            }
            if (this.matchHelper.checkIfNoneMatch(null, request)) {
                log.info("if-none-match comparison failed on null resource, aborting PUT request");
                this.responseHandler.respondPreconditionFailed(request, response, existingResource);
                return;
            }
            CollectionResource parentCol = this.putHelper.findNearestParent(manager, host, path);
            if (!this.handlerHelper.checkAuthorisation(manager, (Resource)parentCol, request)) {
                this.responseHandler.respondUnauthorised((Resource)parentCol, response, request);
                return;
            }
            storageErr = this.handlerHelper.checkStorageOnAdd(request, parentCol, path.getParent(), host);
        }
        if (storageErr != null) {
            this.respondInsufficientStorage(request, response, storageErr);
            return;
        }
        ReplaceableResource replacee = existingResource != null && existingResource instanceof ReplaceableResource ? (ReplaceableResource)existingResource : null;
        if (replacee != null) {
            if (log.isTraceEnabled()) {
                log.trace("replacing content in: " + replacee.getName() + " - " + replacee.getClass());
            }
            long t = System.currentTimeMillis();
            try {
                manager.onProcessResourceStart(request, response, (Resource)replacee);
                this.processReplace(manager, request, response, replacee);
                manager.getEventManager().fireEvent((Event)new PutEvent((Resource)replacee));
            }
            finally {
                t = System.currentTimeMillis() - t;
                manager.onProcessResourceFinish(request, response, (Resource)replacee, t);
            }
        } else {
            String nameToCreate = path.getName();
            CollectionResource folderResource = this.findOrCreateFolders(manager, host, path.getParent(), request);
            if (folderResource != null) {
                long t = System.currentTimeMillis();
                try {
                    if (folderResource instanceof PutableResource) {
                        if (this.handlerHelper.isLockedOut(request, (Resource)folderResource)) {
                            this.respondLocked(request, response, (Resource)folderResource);
                            return;
                        }
                        PutableResource putableResource = (PutableResource)folderResource;
                        this.processCreate(manager, request, response, putableResource, nameToCreate);
                    }
                    LogUtils.debug((Logger)log, (Object[])new Object[]{"method not implemented: PUT on class: ", folderResource.getClass(), folderResource.getName()});
                    manager.getResponseHandler().respondMethodNotImplemented((Resource)folderResource, response, request);
                }
                finally {
                    t = System.currentTimeMillis() - t;
                    manager.onProcessResourceFinish(request, response, (Resource)folderResource, t);
                }
            } else {
                this.responseHandler.respondNotFound(response, request);
            }
        }
    }

    private void processCreate(HttpManager manager, Request request, Response response, PutableResource folder, String newName) throws ConflictException, BadRequestException, NotAuthorizedException {
        LogUtils.debug((Logger)log, (Object[])new Object[]{"process: putting to: ", folder.getName()});
        try {
            Long l = this.putHelper.getContentLength(request);
            String ct = this.putHelper.findContentTypes(request, newName);
            LogUtils.debug((Logger)log, (Object[])new Object[]{"PutHandler: creating resource of type: ", ct});
            Resource newlyCreated = folder.createNew(newName, request.getInputStream(), l, ct);
            if (newlyCreated != null) {
                if (newName != null && !newName.equals(newlyCreated.getName())) {
                    log.warn("getName on the created resource does not match the name requested by the client! requested: " + newName + " - created: " + newlyCreated.getName());
                }
            } else {
                throw new RuntimeException("createNew method on: " + folder.getClass() + " returned a null resource. Must return a reference to the newly created or modified resource");
            }
            manager.getEventManager().fireEvent((Event)new PutEvent(newlyCreated));
            manager.getResponseHandler().respondCreated(newlyCreated, response, request);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException reading input stream. Probably interrupted upload", ex);
        }
    }

    private CollectionResource findOrCreateFolders(HttpManager manager, String host, Path path, Request request) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (path == null) {
            return null;
        }
        Resource thisResource = manager.getResourceFactory().getResource(host, path.toString());
        if (thisResource != null) {
            if (thisResource.getName() != null && !thisResource.getName().equals(path.getName())) {
                log.warn("Your resource factory returned a resource with a different name to that requested!!! Requested: " + path.getName() + " returned: " + thisResource.getName() + " - resource factory: " + manager.getResourceFactory().getClass());
            }
            if (thisResource instanceof CollectionResource) {
                return (CollectionResource)thisResource;
            }
            log.warn("parent is not a collection: " + path);
            return null;
        }
        CollectionResource parent = this.findOrCreateFolders(manager, host, path.getParent(), request);
        if (parent == null) {
            log.warn("couldnt find parent: " + path);
            return null;
        }
        Resource r = parent.child(path.getName());
        if (r == null) {
            log.info("Could not find child: " + path.getName() + " in parent: " + parent.getName() + " - " + parent.getClass());
            if (parent instanceof MakeCollectionableResource) {
                MakeCollectionableResource mkcol = (MakeCollectionableResource)parent;
                if (!this.handlerHelper.checkAuthorisation(manager, (Resource)mkcol, request)) {
                    throw new NotAuthorizedException((Resource)mkcol);
                }
                log.info("autocreating new folder: " + path.getName());
                CollectionResource newCol = mkcol.createCollection(path.getName());
                manager.getEventManager().fireEvent((Event)new NewFolderEvent(newCol));
                return newCol;
            }
            log.info("parent folder isnt a MakeCollectionableResource: " + parent.getName() + " - " + parent.getClass());
            return null;
        }
        if (r instanceof CollectionResource) {
            return (CollectionResource)r;
        }
        log.info("parent in URL is not a collection: " + r.getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplace(HttpManager manager, Request request, Response response, ReplaceableResource replacee) throws BadRequestException, NotAuthorizedException, ConflictException, NotFoundException {
        block8: {
            if (!this.handlerHelper.checkAuthorisation(manager, (Resource)replacee, request)) {
                this.responseHandler.respondUnauthorised((Resource)replacee, response, request);
                return;
            }
            try {
                block9: {
                    block10: {
                        long length;
                        Range range = this.putHelper.parseContentRange((Resource)replacee, request);
                        if (range == null) break block9;
                        log.debug("partial put: " + range);
                        if (replacee instanceof PartialllyUpdateableResource) {
                            log.debug("doing partial put on a PartialllyUpdateableResource");
                            PartialllyUpdateableResource partialllyUpdateableResource = (PartialllyUpdateableResource)replacee;
                            partialllyUpdateableResource.replacePartialContent(range, request.getInputStream());
                            break block8;
                        }
                        if (!(replacee instanceof GetableResource)) break block10;
                        log.debug("doing partial put on a GetableResource");
                        File tempFile = File.createTempFile("milton-partial", null);
                        RandomAccessFile randomAccessFile = null;
                        try {
                            int numBytesRead;
                            randomAccessFile = new RandomAccessFile(tempFile, "rw");
                            RandomFileOutputStream tempOut = new RandomFileOutputStream(tempFile);
                            GetableResource gr = (GetableResource)replacee;
                            gr.sendContent((OutputStream)tempOut, null, null, null);
                            length = randomAccessFile.length();
                            if (range.getFinish() + 1L > length) {
                                length = range.getFinish() + 1L;
                            }
                            randomAccessFile.setLength(length);
                            randomAccessFile.seek(range.getStart());
                            byte[] copyBuffer = new byte[1024];
                            InputStream newContent = request.getInputStream();
                            while ((numBytesRead = newContent.read(copyBuffer)) != -1) {
                                randomAccessFile.write(copyBuffer, 0, numBytesRead);
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(randomAccessFile);
                            throw throwable;
                        }
                        FileUtils.close((Closeable)randomAccessFile);
                        FileInputStream updatedContent = new FileInputStream(tempFile);
                        BufferedInputStream bufin = new BufferedInputStream(updatedContent);
                        replacee.replaceContent((InputStream)bufin, Long.valueOf(length));
                        break block8;
                    }
                    throw new BadRequestException((Resource)replacee, "Cant apply partial update. Resource does not support PartialllyUpdateableResource or GetableResource");
                }
                Long l = request.getContentLengthHeader();
                replacee.replaceContent(request.getInputStream(), l);
            }
            catch (IOException ex) {
                log.warn("IOException reading input stream. Probably interrupted upload: " + ex.getMessage());
                return;
            }
        }
        this.responseHandler.respondNoContent((Resource)replacee, response, request);
        log.debug("process: finished");
    }

    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        String host = request.getHostHeader();
        String urlToCreateOrUpdate = HttpManager.decodeUrl(request.getAbsolutePath());
        log.debug("process request: host: " + host + " url: " + urlToCreateOrUpdate);
        Path path = Path.path((String)urlToCreateOrUpdate);
        urlToCreateOrUpdate = path.toString();
        Resource existingResource = manager.getResourceFactory().getResource(host, urlToCreateOrUpdate);
        if (existingResource != null && this.handlerHelper.isLockedOut(request, existingResource)) {
            log.warn("resource is locked, but not by the current user");
            response.setStatus(Response.Status.SC_LOCKED);
            return;
        }
        ReplaceableResource replacee = existingResource != null && existingResource instanceof ReplaceableResource ? (ReplaceableResource)existingResource : null;
        if (replacee != null) {
            this.processReplace(manager, request, response, (ReplaceableResource)existingResource);
        } else {
            String urlFolder = path.getParent().toString();
            String nameToCreate = path.getName();
            CollectionResource folderResource = this.findOrCreateFolders(manager, host, path.getParent(), request);
            if (folderResource != null) {
                if (log.isDebugEnabled()) {
                    log.debug("found folder: " + urlFolder + " - " + folderResource.getClass());
                }
                if (folderResource instanceof PutableResource) {
                    if (this.handlerHelper.isLockedOut(request, (Resource)folderResource)) {
                        response.setStatus(Response.Status.SC_LOCKED);
                        return;
                    }
                    PutableResource putableResource = (PutableResource)folderResource;
                    this.processCreate(manager, request, response, putableResource, nameToCreate);
                } else {
                    this.responseHandler.respondMethodNotImplemented((Resource)folderResource, response, request);
                }
            } else {
                this.responseHandler.respondNotFound(response, request);
            }
        }
    }

    private void respondLocked(Request request, Response response, Resource existingResource) {
        if (this.responseHandler instanceof WebDavResponseHandler) {
            WebDavResponseHandler rh = (WebDavResponseHandler)this.responseHandler;
            rh.respondLocked(request, response, existingResource);
        } else {
            response.setStatus(Response.Status.SC_LOCKED);
        }
    }

    private void respondInsufficientStorage(Request request, Response response, StorageChecker.StorageErrorReason storageErrorReason) {
        if (this.responseHandler instanceof WebDavResponseHandler) {
            WebDavResponseHandler rh = (WebDavResponseHandler)this.responseHandler;
            rh.respondInsufficientStorage(request, response, storageErrorReason);
        } else {
            response.setStatus(Response.Status.SC_INSUFFICIENT_STORAGE);
        }
    }
}

