/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.values;

import io.milton.http.XmlWriter;
import io.milton.http.values.ValueWriter;
import io.milton.principal.PriviledgeList;
import io.milton.resource.AccessControlledResource;
import java.util.EnumMap;
import java.util.Map;

public class PriviledgeListValueWriter
implements ValueWriter {
    private static final Map<AccessControlledResource.Priviledge, String> priviledgeToStringMap = PriviledgeListValueWriter.initPriviledgeToStringMap();

    private static Map<AccessControlledResource.Priviledge, String> initPriviledgeToStringMap() {
        EnumMap<AccessControlledResource.Priviledge, String> map = new EnumMap<AccessControlledResource.Priviledge, String>(AccessControlledResource.Priviledge.class);
        map.put(AccessControlledResource.Priviledge.READ, "read");
        map.put(AccessControlledResource.Priviledge.WRITE, "write");
        map.put(AccessControlledResource.Priviledge.READ_ACL, "read-acl");
        map.put(AccessControlledResource.Priviledge.WRITE_ACL, "write-acl");
        map.put(AccessControlledResource.Priviledge.UNLOCK, "unlock");
        map.put(AccessControlledResource.Priviledge.READ_CURRENT_USER_PRIVILEDGE, "read-current-user-privilege-set");
        map.put(AccessControlledResource.Priviledge.WRITE_PROPERTIES, "write-properties");
        map.put(AccessControlledResource.Priviledge.WRITE_CONTENT, "write-content");
        map.put(AccessControlledResource.Priviledge.BIND, "bind");
        map.put(AccessControlledResource.Priviledge.UNBIND, "unbind");
        map.put(AccessControlledResource.Priviledge.ALL, "all");
        return map;
    }

    @Override
    public boolean supports(String nsUri, String localName, Class c) {
        return PriviledgeList.class.isAssignableFrom(c);
    }

    @Override
    public void writeValue(XmlWriter writer, String nsUri, String prefix, String localName, Object val, String href, Map<String, String> nsPrefixes) {
        if (val instanceof PriviledgeList) {
            PriviledgeList list = (PriviledgeList)val;
            XmlWriter.Element outerEl = writer.begin(prefix, localName).open();
            if (list != null) {
                for (AccessControlledResource.Priviledge p : list) {
                    String privilegeString = priviledgeToStringMap.get(p);
                    if (privilegeString == null) continue;
                    XmlWriter.Element privilegeEl = writer.begin("d:privilege").open(false);
                    XmlWriter.Element privilegeValueEl = privilegeEl.begin("d", privilegeString);
                    privilegeValueEl.noContent();
                    privilegeEl.close();
                }
            }
            outerEl.close();
        } else if (val != null) {
            throw new RuntimeException("Value is not correct type. Is a: " + val.getClass());
        }
    }

    @Override
    public Object parse(String namespaceURI, String localPart, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

