/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropFindSaxHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(PropFindSaxHandler.class);
    private final Stack<QName> elementPath = new Stack();
    private final Map<QName, String> attributes = new HashMap<QName, String>();
    private final StringBuilder sb = new StringBuilder();
    private boolean inProp;
    private boolean allProp;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String elname;
        if (this.elementPath.size() > 0 && (elname = this.elementPath.peek().getLocalPart()).equals("prop")) {
            this.inProp = true;
        }
        if (localName.equals("allprop")) {
            this.allProp = true;
        }
        QName qname = new QName(uri, localName);
        this.elementPath.push(qname);
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inProp) {
            this.sb.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (this.elementPath.size() > 0 && this.elementPath.peek().getLocalPart().endsWith("prop")) {
            if (this.sb != null) {
                QName qname = new QName(uri, localName);
                this.getAttributes().put(qname, this.sb.toString().trim());
            }
            this.sb.delete(0, this.sb.length());
        }
        super.endElement(uri, localName, name);
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public boolean isAllProp() {
        return this.allProp;
    }
}

