/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.handler;

import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.MessageHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import lombok.Generated;

public class NewLineDelimitedMessageHandler
implements MessageHandler {
    private final MessageFormatter formatter = new JsonMessageFormatter();
    private final InputStream inputStream;
    private final OutputStream outputStream;

    @Override
    public JsonRpcMessage receive() {
        try {
            int b;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((b = this.inputStream.read()) != -1) {
                buffer.write(b);
                if (b != 10) continue;
            }
            return this.formatter.deserialize(new ByteArrayInputStream(buffer.toByteArray()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void send(JsonRpcMessage msg) {
        try {
            this.formatter.serialize(msg, this.outputStream);
            this.outputStream.write(new byte[]{10});
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public NewLineDelimitedMessageHandler(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }
}

