/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.sctp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.sctp.SctpChannel;
import io.netty.handler.codec.sctp.SctpInboundByteStreamHandler;
import io.netty.handler.codec.sctp.SctpMessageCompletionHandler;
import io.netty.handler.codec.sctp.SctpOutboundByteStreamHandler;
import io.netty.testsuite.transport.sctp.AbstractSctpTest;
import io.netty.testsuite.util.TestUtils;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SctpEchoTest
extends AbstractSctpTest {
    private static final Random random = new Random();
    static final byte[] data = new byte[4096];

    @Test
    public void testSimpleEcho() throws Throwable {
        Assume.assumeTrue((boolean)TestUtils.isSctpSupported());
        this.run();
    }

    public void testSimpleEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SctpEchoTest.testSimpleEcho0(sb, cb, false);
    }

    @Test
    public void testSimpleEchoUnordered() throws Throwable {
        Assume.assumeTrue((boolean)TestUtils.isSctpSupported());
        this.run();
    }

    public void testSimpleEchoUnordered(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SctpEchoTest.testSimpleEcho0(sb, cb, true);
    }

    private static void testSimpleEcho0(ServerBootstrap sb, Bootstrap cb, final boolean unordered) throws Throwable {
        int length;
        final EchoHandler sh = new EchoHandler();
        final EchoHandler ch = new EchoHandler();
        sb.childHandler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

            public void initChannel(SctpChannel c) throws Exception {
                c.pipeline().addLast(new ChannelHandler[]{new SctpMessageCompletionHandler(), new SctpInboundByteStreamHandler(0, 0), new SctpOutboundByteStreamHandler(0, 0, unordered), sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

            public void initChannel(SctpChannel c) throws Exception {
                c.pipeline().addLast(new ChannelHandler[]{new SctpMessageCompletionHandler(), new SctpInboundByteStreamHandler(0, 0), new SctpOutboundByteStreamHandler(0, 0, unordered), ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length));
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        private EchoHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            if (this.channel.parent() != null) {
                this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])actual));
            }
            this.counter += actual.length;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

