/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Supplier;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableUsing<T, D>
extends Flowable<T> {
    final Supplier<? extends D> resourceSupplier;
    final Function<? super D, ? extends Publisher<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public FlowableUsing(Supplier<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher<? extends T> source;
        D resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(new CompositeException(e, ex), s);
                return;
            }
            EmptySubscription.error(e, s);
            return;
        }
        UsingSubscriber<? super T, ? super D> us = new UsingSubscriber<T, D>(s, resource, this.disposer, this.eager);
        source.subscribe(us);
    }

    static final class UsingSubscriber<T, D>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 5904473792286235046L;
        final Subscriber<? super T> downstream;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Subscription upstream;

        UsingSubscriber(Subscriber<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.eager) {
                Throwable innerError = null;
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        innerError = e;
                    }
                }
                this.upstream.cancel();
                if (innerError != null) {
                    this.downstream.onError((Throwable)new CompositeException(t, innerError));
                } else {
                    this.downstream.onError(t);
                }
            } else {
                this.downstream.onError(t);
                this.upstream.cancel();
                this.disposeResource();
            }
        }

        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.downstream.onError(e);
                        return;
                    }
                }
                this.upstream.cancel();
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.upstream.cancel();
                this.disposeResource();
            }
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
            } else {
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    RxJavaPlugins.onError(e);
                }
            }
        }
    }
}

