/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Supplier;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableGenerate<T, S>
extends Observable<T> {
    final Supplier<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public ObservableGenerate(Supplier<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        S state;
        try {
            state = this.stateSupplier.get();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, observer);
            return;
        }
        GeneratorDisposable<T, S> gd = new GeneratorDisposable<T, S>(observer, this.generator, this.disposeState, state);
        observer.onSubscribe(gd);
        gd.run();
    }

    static final class GeneratorDisposable<T, S>
    implements Emitter<T>,
    Disposable {
        final Observer<? super T> downstream;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorDisposable(Observer<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.downstream = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        public void run() {
            S s = this.state;
            if (this.cancelled) {
                this.state = null;
                this.dispose(s);
                return;
            }
            BiFunction<S, Emitter<T>, S> f = this.generator;
            do {
                if (this.cancelled) {
                    this.state = null;
                    this.dispose(s);
                    return;
                }
                this.hasNext = false;
                try {
                    s = f.apply(s, this);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.state = null;
                    this.cancelled = true;
                    this.onError(ex);
                    this.dispose(s);
                    return;
                }
            } while (!this.terminate);
            this.cancelled = true;
            this.state = null;
            this.dispose(s);
        }

        private void dispose(S s) {
            try {
                this.disposeState.accept(s);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void onNext(T t) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t == null) {
                    this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                } else {
                    this.hasNext = true;
                    this.downstream.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.terminate) {
                RxJavaPlugins.onError(t);
            } else {
                if (t == null) {
                    t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
                }
                this.terminate = true;
                this.downstream.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.downstream.onComplete();
            }
        }
    }
}

