/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmResults;

public abstract class RealmRecyclerViewAdapter<T extends RealmModel, S extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<S> {
    private final boolean hasAutoUpdates;
    private final boolean updateOnModification;
    private final OrderedRealmCollectionChangeListener listener;
    @Nullable
    private OrderedRealmCollection<T> adapterData;

    private OrderedRealmCollectionChangeListener createListener() {
        return new OrderedRealmCollectionChangeListener(){

            public void onChange(Object collection, OrderedCollectionChangeSet changeSet) {
                OrderedCollectionChangeSet.Range[] modifications;
                OrderedCollectionChangeSet.Range[] insertions;
                if (changeSet.getState() == OrderedCollectionChangeSet.State.INITIAL) {
                    RealmRecyclerViewAdapter.this.notifyDataSetChanged();
                    return;
                }
                OrderedCollectionChangeSet.Range[] deletions = changeSet.getDeletionRanges();
                for (int i = deletions.length - 1; i >= 0; --i) {
                    OrderedCollectionChangeSet.Range[] range = deletions[i];
                    RealmRecyclerViewAdapter.this.notifyItemRangeRemoved(range.startIndex + RealmRecyclerViewAdapter.this.dataOffset(), range.length);
                }
                for (OrderedCollectionChangeSet.Range range : insertions = changeSet.getInsertionRanges()) {
                    RealmRecyclerViewAdapter.this.notifyItemRangeInserted(range.startIndex + RealmRecyclerViewAdapter.this.dataOffset(), range.length);
                }
                if (!RealmRecyclerViewAdapter.this.updateOnModification) {
                    return;
                }
                for (OrderedCollectionChangeSet.Range range : modifications = changeSet.getChangeRanges()) {
                    RealmRecyclerViewAdapter.this.notifyItemRangeChanged(range.startIndex + RealmRecyclerViewAdapter.this.dataOffset(), range.length);
                }
            }
        };
    }

    public int dataOffset() {
        return 0;
    }

    public RealmRecyclerViewAdapter(@Nullable OrderedRealmCollection<T> data, boolean autoUpdate) {
        this(data, autoUpdate, true);
    }

    public RealmRecyclerViewAdapter(@Nullable OrderedRealmCollection<T> data, boolean autoUpdate, boolean updateOnModification) {
        if (data != null && !data.isManaged()) {
            throw new IllegalStateException("Only use this adapter with managed RealmCollection, for un-managed lists you can just use the BaseRecyclerViewAdapter");
        }
        this.adapterData = data;
        this.hasAutoUpdates = autoUpdate;
        this.listener = this.hasAutoUpdates ? this.createListener() : null;
        this.updateOnModification = updateOnModification;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.hasAutoUpdates && this.isDataValid()) {
            this.addListener(this.adapterData);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.hasAutoUpdates && this.isDataValid()) {
            this.removeListener(this.adapterData);
        }
    }

    public int getItemCount() {
        return this.isDataValid() ? this.adapterData.size() : 0;
    }

    @Nullable
    public T getItem(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Only indexes >= 0 are allowed. Input was: " + index);
        }
        if (this.adapterData != null && index >= this.adapterData.size()) {
            return null;
        }
        return (T)(this.isDataValid() ? (RealmModel)this.adapterData.get(index) : null);
    }

    @Nullable
    public OrderedRealmCollection<T> getData() {
        return this.adapterData;
    }

    public void updateData(@Nullable OrderedRealmCollection<T> data) {
        if (this.hasAutoUpdates) {
            if (this.isDataValid()) {
                this.removeListener(this.adapterData);
            }
            if (data != null) {
                this.addListener(data);
            }
        }
        this.adapterData = data;
        this.notifyDataSetChanged();
    }

    private void addListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults results = (RealmResults)data;
            results.addChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList list = (RealmList)data;
            list.addChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private void removeListener(@NonNull OrderedRealmCollection<T> data) {
        if (data instanceof RealmResults) {
            RealmResults results = (RealmResults)data;
            results.removeChangeListener(this.listener);
        } else if (data instanceof RealmList) {
            RealmList list = (RealmList)data;
            list.removeChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + data.getClass());
        }
    }

    private boolean isDataValid() {
        return this.adapterData != null && this.adapterData.isValid();
    }
}

