/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.SyncConfiguration;
import java.io.File;

public class ClientResetRequiredError
extends ObjectServerError {
    private final SyncConfiguration originalConfiguration;
    private final RealmConfiguration backupConfiguration;
    private final File backupFile;
    private final File originalFile;

    ClientResetRequiredError(ErrorCode errorCode, String errorMessage, SyncConfiguration originalConfiguration, RealmConfiguration backupConfiguration) {
        super(errorCode, errorMessage);
        this.originalConfiguration = originalConfiguration;
        this.backupConfiguration = backupConfiguration;
        this.backupFile = new File(backupConfiguration.getPath());
        this.originalFile = new File(originalConfiguration.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeClientReset() {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            if (Realm.getGlobalInstanceCount(this.originalConfiguration) > 0) {
                throw new IllegalStateException("Realm has not been fully closed. Client Reset cannot run before all instances have been closed.");
            }
            this.nativeExecuteClientReset(this.originalConfiguration.getPath());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public RealmConfiguration getBackupRealmConfiguration() {
        return this.backupConfiguration;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    private native void nativeExecuteClientReset(String var1);
}

