/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ProxyState;
import io.realm.RealmModel;
import io.realm.internal.ManagableObject;
import io.realm.internal.Row;
import io.realm.internal.Table;
import javax.annotation.Nullable;

public abstract class MutableRealmInteger
implements Comparable<MutableRealmInteger>,
ManagableObject {
    public static MutableRealmInteger valueOf(Long value) {
        return new Unmanaged(value);
    }

    public static MutableRealmInteger ofNull() {
        return new Unmanaged(null);
    }

    public static MutableRealmInteger valueOf(long value) {
        return MutableRealmInteger.valueOf((Long)value);
    }

    public static MutableRealmInteger valueOf(String value) {
        return MutableRealmInteger.valueOf(Long.parseLong(value));
    }

    MutableRealmInteger() {
    }

    @Nullable
    public abstract Long get();

    public abstract void set(@Nullable Long var1);

    public final void set(long newValue) {
        this.set((Long)newValue);
    }

    public abstract void increment(long var1);

    public abstract void decrement(long var1);

    public final boolean isNull() {
        return this.get() == null;
    }

    @Override
    public final int compareTo(MutableRealmInteger o) {
        Long thisValue = this.get();
        Long otherValue = o.get();
        return thisValue == null ? (otherValue == null ? 0 : -1) : (otherValue == null ? 1 : thisValue.compareTo(otherValue));
    }

    public final int hashCode() {
        Long thisValue = this.get();
        return thisValue == null ? 0 : thisValue.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableRealmInteger)) {
            return false;
        }
        Long thisValue = this.get();
        Long otherValue = ((MutableRealmInteger)o).get();
        return thisValue == null ? otherValue == null : thisValue.equals(otherValue);
    }

    static abstract class Managed<T extends RealmModel>
    extends MutableRealmInteger {
        Managed() {
        }

        protected abstract ProxyState<T> getProxyState();

        protected abstract long getColumnIndex();

        @Override
        public final boolean isManaged() {
            return true;
        }

        @Override
        public final boolean isValid() {
            return !this.getRealm().isClosed() && this.getRow().isAttached();
        }

        @Override
        public final Long get() {
            Row row = this.getRow();
            row.checkIfAttached();
            long columnIndex = this.getColumnIndex();
            return row.isNull(columnIndex) ? null : Long.valueOf(row.getLong(columnIndex));
        }

        @Override
        public final void set(@Nullable Long value) {
            ProxyState<T> proxyState = this.getProxyState();
            proxyState.getRealm$realm().checkIfValidAndInTransaction();
            if (!proxyState.isUnderConstruction()) {
                this.setValue(value, false);
                return;
            }
            if (!proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            this.setValue(value, true);
        }

        @Override
        public final void increment(long inc) {
            this.getRealm().checkIfValidAndInTransaction();
            Row row = this.getRow();
            row.getTable().incrementLong(this.getColumnIndex(), row.getIndex(), inc);
        }

        @Override
        public final void decrement(long dec) {
            this.increment(-dec);
        }

        private BaseRealm getRealm() {
            return this.getProxyState().getRealm$realm();
        }

        private Row getRow() {
            return this.getProxyState().getRow$realm();
        }

        private void setValue(@Nullable Long value, boolean isDefault) {
            Row row = this.getRow();
            Table table = row.getTable();
            long rowIndex = row.getIndex();
            long columnIndex = this.getColumnIndex();
            if (value == null) {
                table.setNull(columnIndex, rowIndex, isDefault);
            } else {
                table.setLong(columnIndex, rowIndex, value, isDefault);
            }
        }
    }

    private static final class Unmanaged
    extends MutableRealmInteger {
        @Nullable
        private Long value;

        Unmanaged(@Nullable Long value) {
            this.value = value;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void set(@Nullable Long newValue) {
            this.value = newValue;
        }

        @Override
        @Nullable
        public Long get() {
            return this.value;
        }

        @Override
        public void increment(long inc) {
            if (this.value == null) {
                throw new IllegalStateException("Cannot increment a MutableRealmInteger whose value is null. Set its value first.");
            }
            this.value = this.value + inc;
        }

        @Override
        public void decrement(long dec) {
            this.increment(-dec);
        }
    }
}

