/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Process;
import io.realm.RealmFileUserStore;
import io.realm.SyncManager;
import io.realm.internal.Keep;
import io.realm.internal.Util;
import io.realm.log.RealmLog;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

@Keep
class ObjectServer {
    ObjectServer() {
    }

    public static void init(Context context, String appDefinedUserAgent) {
        String appId = "unknown";
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            appId = pi.packageName;
        }
        catch (Exception pi) {
            // empty catch block
        }
        String userAgentBindingInfo = "Unknown";
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("RealmJava/");
            sb.append("6.1.0");
            sb.append(" (");
            sb.append(Util.isEmptyString(Build.DEVICE) ? "unknown-device" : Build.DEVICE);
            sb.append(", ");
            sb.append(Util.isEmptyString(Build.MODEL) ? "unknown-model" : Build.MODEL);
            sb.append(", v");
            sb.append(Build.VERSION.SDK_INT);
            sb.append(")");
            userAgentBindingInfo = sb.toString();
        }
        catch (Exception e) {
            RealmLog.warn("Constructing User-Agent description failed.", e);
        }
        if (SyncManager.Debug.separatedDirForSyncManager) {
            try {
                File dir = File.createTempFile("remote_sync_", "_" + Process.myPid(), context.getFilesDir());
                if (!dir.delete()) {
                    throw new IllegalStateException(String.format(Locale.US, "Temp file '%s' cannot be deleted.", dir.getPath()));
                }
                if (!dir.mkdir()) {
                    throw new IllegalStateException(String.format(Locale.US, "Directory '%s' for SyncManager cannot be created. ", dir.getPath()));
                }
                SyncManager.nativeInitializeSyncManager(dir.getPath(), userAgentBindingInfo, appDefinedUserAgent);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            SyncManager.nativeInitializeSyncManager(context.getFilesDir().getPath(), userAgentBindingInfo, appDefinedUserAgent);
        }
        RealmFileUserStore userStore = new RealmFileUserStore();
        SyncManager.init(appId, userStore);
    }
}

