/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.ErrorCode;
import io.realm.internal.Util;
import javax.annotation.Nullable;

public class ObjectServerError
extends RuntimeException {
    private final ErrorCode error;
    private final String nativeErrorType;
    private final int nativeErrorIntValue;
    private final String errorMessage;
    private final Throwable exception;

    public ObjectServerError(ErrorCode errorCode, String errorMessage) {
        this(errorCode, errorCode.getType(), errorCode.intValue(), errorMessage, null);
    }

    public ObjectServerError(String errorType, int errorCode, String errorMessage) {
        this(ErrorCode.UNKNOWN, errorType, errorCode, errorMessage, null);
    }

    public ObjectServerError(ErrorCode errorCode, Throwable exception) {
        this(errorCode, null, exception);
    }

    public ObjectServerError(ErrorCode errorCode, String title, @Nullable String hint) {
        this(errorCode, hint != null ? title + " : " + hint : title, (Throwable)null);
    }

    public ObjectServerError(ErrorCode errorCode, @Nullable String errorMessage, @Nullable Throwable exception) {
        this(errorCode, errorCode.getType(), errorCode.intValue(), errorMessage, exception);
    }

    public ObjectServerError(ErrorCode errorCode, String nativeErrorType, int nativeErrorCode, @Nullable String errorMessage, @Nullable Throwable exception) {
        this.error = errorCode;
        this.nativeErrorType = nativeErrorType;
        this.nativeErrorIntValue = nativeErrorCode;
        this.errorMessage = errorMessage;
        this.exception = exception;
    }

    public ErrorCode getErrorCode() {
        return this.error;
    }

    public String getErrorType() {
        return this.nativeErrorType;
    }

    public int getErrorIntValue() {
        return this.nativeErrorIntValue;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public ErrorCode.Category getCategory() {
        return this.error.getCategory();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getErrorCode().name());
        sb.append("(");
        sb.append(this.getErrorType());
        sb.append(":");
        sb.append(this.getErrorIntValue());
        sb.append(')');
        if (this.errorMessage != null) {
            sb.append(": ");
            sb.append(this.errorMessage);
        }
        if (this.exception != null) {
            sb.append('\n');
            sb.append(Util.getStackTrace(this.exception));
        }
        return sb.toString();
    }
}

