/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.BaseRealm;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmResults;
import io.realm.SchemaConnector;
import io.realm.Sort;
import io.realm.internal.InvalidRow;
import io.realm.internal.OsResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.core.QueryDescriptor;
import io.realm.internal.fields.FieldDescriptor;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.annotation.Nullable;

abstract class OrderedRealmCollectionImpl<E>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String NOT_SUPPORTED_MESSAGE = "This method is not supported by 'RealmResults' or 'OrderedRealmCollectionSnapshot'.";
    final BaseRealm realm;
    @Nullable
    final Class<E> classSpec;
    @Nullable
    final String className;
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    final boolean forValues = false;
    final OsResults osResults;

    OrderedRealmCollectionImpl(BaseRealm realm, OsResults osResults, Class<E> clazz) {
        this(realm, osResults, clazz, null);
    }

    OrderedRealmCollectionImpl(BaseRealm realm, OsResults osResults, String className) {
        this(realm, osResults, null, className);
    }

    private OrderedRealmCollectionImpl(BaseRealm realm, OsResults osResults, @Nullable Class<E> clazz, @Nullable String className) {
        this.realm = realm;
        this.osResults = osResults;
        this.classSpec = clazz;
        this.className = className;
    }

    Table getTable() {
        return this.osResults.getTable();
    }

    OsResults getOsResults() {
        return this.osResults;
    }

    @Override
    public boolean isValid() {
        return this.osResults.isValid();
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.isLoaded()) {
            RealmObjectProxy proxy;
            if (object instanceof RealmObjectProxy && (proxy = (RealmObjectProxy)object).realmGet$proxyState().getRow$realm() == InvalidRow.INSTANCE) {
                return false;
            }
            for (E e : this) {
                if (!e.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public E get(int location) {
        this.realm.checkIfValid();
        return this.realm.get(this.classSpec, this.className, this.osResults.getUncheckedRow(location));
    }

    @Override
    @Nullable
    public E first() {
        return this.firstImpl(true, null);
    }

    @Override
    @Nullable
    public E first(@Nullable E defaultValue) {
        return this.firstImpl(false, defaultValue);
    }

    @Nullable
    private E firstImpl(boolean shouldThrow, @Nullable E defaultValue) {
        UncheckedRow row = this.osResults.firstUncheckedRow();
        if (row != null) {
            return this.realm.get(this.classSpec, this.className, row);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("No results were found.");
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public E last() {
        return this.lastImpl(true, null);
    }

    @Override
    @Nullable
    public E last(@Nullable E defaultValue) {
        return this.lastImpl(false, defaultValue);
    }

    @Nullable
    private E lastImpl(boolean shouldThrow, @Nullable E defaultValue) {
        UncheckedRow row = this.osResults.lastUncheckedRow();
        if (row != null) {
            return this.realm.get(this.classSpec, this.className, row);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("No results were found.");
        }
        return defaultValue;
    }

    @Override
    public void deleteFromRealm(int location) {
        this.realm.checkIfValidAndInTransaction();
        this.osResults.delete(location);
    }

    @Override
    public boolean deleteAllFromRealm() {
        this.realm.checkIfValid();
        if (this.size() > 0) {
            this.osResults.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new RealmCollectionIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new RealmCollectionListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new RealmCollectionListIterator(location);
    }

    private long getColumnIndexForSort(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Non-empty field name required.");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Aggregates on child object fields are not supported: " + fieldName);
        }
        long columnIndex = this.osResults.getTable().getColumnIndex(fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format(Locale.US, "Field '%s' does not exist.", fieldName));
        }
        return columnIndex;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        QueryDescriptor sortDescriptor = QueryDescriptor.getInstanceForSort((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.osResults.getTable(), fieldName, Sort.ASCENDING);
        OsResults sortedOsResults = this.osResults.sort(sortDescriptor);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        QueryDescriptor sortDescriptor = QueryDescriptor.getInstanceForSort((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.osResults.getTable(), fieldName, sortOrder);
        OsResults sortedOsResults = this.osResults.sort(sortDescriptor);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        QueryDescriptor sortDescriptor = QueryDescriptor.getInstanceForSort((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.osResults.getTable(), fieldNames, sortOrders);
        OsResults sortedOsResults = this.osResults.sort(sortDescriptor);
        return this.createLoadedResults(sortedOsResults);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public int size() {
        if (this.isLoaded()) {
            long size = this.osResults.size();
            return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
        }
        return 0;
    }

    @Override
    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.MINIMUM, columnIndex);
    }

    @Override
    public Date minDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        return this.osResults.aggregateDate(OsResults.Aggregate.MINIMUM, columnIndex);
    }

    @Override
    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.MAXIMUM, columnIndex);
    }

    @Override
    @Nullable
    public Date maxDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        return this.osResults.aggregateDate(OsResults.Aggregate.MAXIMUM, columnIndex);
    }

    @Override
    public Number sum(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        return this.osResults.aggregateNumber(OsResults.Aggregate.SUM, columnIndex);
    }

    @Override
    public double average(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.getColumnIndexForSort(fieldName);
        Number avg = this.osResults.aggregateNumber(OsResults.Aggregate.AVERAGE, columnIndex);
        return avg.doubleValue();
    }

    @Override
    @Deprecated
    public E remove(int index) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public E set(int location, E object) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        this.realm.checkIfValidAndInTransaction();
        return this.osResults.deleteLast();
    }

    @Override
    public boolean deleteFirstFromRealm() {
        this.realm.checkIfValidAndInTransaction();
        return this.osResults.deleteFirst();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean add(E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(int location, Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public OrderedRealmCollectionSnapshot<E> createSnapshot() {
        if (this.className != null) {
            return new OrderedRealmCollectionSnapshot(this.realm, this.osResults, this.className);
        }
        return new OrderedRealmCollectionSnapshot<E>(this.realm, this.osResults, this.classSpec);
    }

    public Realm getRealm() {
        this.realm.checkIfValid();
        if (!(this.realm instanceof Realm)) {
            throw new IllegalStateException("This method is only available for typed Realms");
        }
        return (Realm)this.realm;
    }

    RealmResults<E> createLoadedResults(OsResults newOsResults) {
        RealmResults results = this.className != null ? new RealmResults(this.realm, newOsResults, this.className) : new RealmResults<E>(this.realm, newOsResults, this.classSpec);
        results.load();
        return results;
    }

    private SchemaConnector getSchemaConnector() {
        return new SchemaConnector(this.realm.getSchema());
    }

    private class RealmCollectionListIterator
    extends OsResults.ListIterator<E> {
        RealmCollectionListIterator(int start) {
            super(OrderedRealmCollectionImpl.this.osResults, start);
        }

        @Override
        protected E convertRowToObject(UncheckedRow row) {
            return OrderedRealmCollectionImpl.this.realm.get(OrderedRealmCollectionImpl.this.classSpec, OrderedRealmCollectionImpl.this.className, row);
        }
    }

    private class RealmCollectionIterator
    extends OsResults.Iterator<E> {
        RealmCollectionIterator() {
            super(OrderedRealmCollectionImpl.this.osResults);
        }

        @Override
        protected E convertRowToObject(UncheckedRow row) {
            return OrderedRealmCollectionImpl.this.realm.get(OrderedRealmCollectionImpl.this.classSpec, OrderedRealmCollectionImpl.this.className, row);
        }
    }
}

