/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.log.RealmLog;

public class Progress {
    private final long transferredBytes;
    private final long transferableBytes;

    Progress(long transferredBytes, long transferableBytes) {
        this.transferredBytes = transferredBytes;
        this.transferableBytes = transferableBytes;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public long getTransferableBytes() {
        return this.transferableBytes;
    }

    public double getFractionTransferred() {
        if (this.transferableBytes == 0L) {
            return 1.0;
        }
        double percentage = (double)this.transferredBytes / (double)this.transferableBytes;
        if (percentage > 1.0) {
            RealmLog.error("Invalid progress state: %s", this);
            return 1.0;
        }
        return percentage;
    }

    public boolean isTransferComplete() {
        return this.transferredBytes >= this.transferableBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Progress progress = (Progress)o;
        if (this.transferredBytes != progress.transferredBytes) {
            return false;
        }
        return this.transferableBytes == progress.transferableBytes;
    }

    public int hashCode() {
        int result = (int)(this.transferredBytes ^ this.transferredBytes >>> 32);
        result = 31 * result + (int)(this.transferableBytes ^ this.transferableBytes >>> 32);
        return result;
    }

    public String toString() {
        return "Progress{transferredBytes=" + this.transferredBytes + ", transferableBytes=" + this.transferableBytes + '}';
    }
}

