/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.SyncUser;
import io.realm.UserStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class RealmFileUserStore
implements UserStore {
    @Override
    public void put(SyncUser user) {
        String userJson = user.toJson();
        RealmFileUserStore.nativeUpdateOrCreateUser(user.getIdentity(), userJson, user.getAuthenticationUrl().toString());
    }

    @Override
    @Nullable
    public SyncUser getCurrent() {
        String userJson = RealmFileUserStore.nativeGetCurrentUser();
        return RealmFileUserStore.toSyncUserOrNull(userJson);
    }

    @Override
    @Nullable
    public SyncUser get(String identity, String authUrl) {
        String userJson = RealmFileUserStore.nativeGetUser(identity, authUrl);
        return RealmFileUserStore.toSyncUserOrNull(userJson);
    }

    @Override
    public void remove(String identity, String authUrl) {
        RealmFileUserStore.nativeLogoutUser(identity, authUrl);
    }

    @Override
    public Collection<SyncUser> allUsers() {
        String[] allUsers = RealmFileUserStore.nativeGetAllUsers();
        if (allUsers != null && allUsers.length > 0) {
            ArrayList<SyncUser> users = new ArrayList<SyncUser>(allUsers.length);
            for (String userJson : allUsers) {
                users.add(SyncUser.fromJson(userJson));
            }
            return users;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isActive(String identity, String authenticationUrl) {
        return RealmFileUserStore.nativeIsActive(identity, authenticationUrl);
    }

    @Nullable
    private static SyncUser toSyncUserOrNull(@Nullable String userJson) {
        if (userJson == null) {
            return null;
        }
        return SyncUser.fromJson(userJson);
    }

    protected static native String nativeGetCurrentUser();

    @Nullable
    protected static native String nativeGetUser(String var0, String var1);

    protected static native String[] nativeGetAllUsers();

    protected static native void nativeUpdateOrCreateUser(String var0, String var1, String var2);

    protected static native void nativeLogoutUser(String var0, String var1);

    protected static native boolean nativeIsActive(String var0, String var1);
}

