/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.FieldAttribute;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmObject;
import io.realm.RealmSchema;
import io.realm.SchemaConnector;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.Table;
import io.realm.internal.fields.FieldDescriptor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RealmObjectSchema {
    static final Map<Class<?>, FieldMetaData> SUPPORTED_SIMPLE_FIELDS;
    static final Map<Class<?>, FieldMetaData> SUPPORTED_LINKED_FIELDS;
    final RealmSchema schema;
    final BaseRealm realm;
    final Table table;
    private final ColumnInfo columnInfo;

    RealmObjectSchema(BaseRealm realm, RealmSchema schema, Table table, ColumnInfo columnInfo) {
        this.schema = schema;
        this.realm = realm;
        this.table = table;
        this.columnInfo = columnInfo;
    }

    public String getClassName() {
        return this.table.getClassName();
    }

    public abstract RealmObjectSchema setClassName(String var1);

    public abstract RealmObjectSchema addField(String var1, Class<?> var2, FieldAttribute ... var3);

    public abstract RealmObjectSchema addRealmObjectField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmListField(String var1, RealmObjectSchema var2);

    public abstract RealmObjectSchema addRealmListField(String var1, Class<?> var2);

    public abstract RealmObjectSchema removeField(String var1);

    public abstract RealmObjectSchema renameField(String var1, String var2);

    public boolean hasField(String fieldName) {
        return this.table.getColumnIndex(fieldName) != -1L;
    }

    public abstract RealmObjectSchema addIndex(String var1);

    public boolean hasIndex(String fieldName) {
        RealmObjectSchema.checkLegalName(fieldName);
        this.checkFieldExists(fieldName);
        return this.table.hasSearchIndex(this.table.getColumnIndex(fieldName));
    }

    public abstract RealmObjectSchema removeIndex(String var1);

    public abstract RealmObjectSchema addPrimaryKey(String var1);

    public abstract RealmObjectSchema removePrimaryKey();

    public abstract RealmObjectSchema setRequired(String var1, boolean var2);

    public abstract RealmObjectSchema setNullable(String var1, boolean var2);

    public boolean isRequired(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return !this.table.isColumnNullable(columnIndex);
    }

    public boolean isNullable(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return this.table.isColumnNullable(columnIndex);
    }

    public boolean isPrimaryKey(String fieldName) {
        this.checkFieldExists(fieldName);
        return fieldName.equals(OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName()));
    }

    public boolean hasPrimaryKey() {
        return OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName()) != null;
    }

    public String getPrimaryKey() {
        String pkField = OsObjectStore.getPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName());
        if (pkField == null) {
            throw new IllegalStateException(this.getClassName() + " doesn't have a primary key.");
        }
        return pkField;
    }

    public Set<String> getFieldNames() {
        int columnCount = (int)this.table.getColumnCount();
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            String name = this.table.getColumnName(i);
            if (OsObject.isObjectIdColumn(name)) continue;
            columnNames.add(name);
        }
        return columnNames;
    }

    public abstract RealmObjectSchema transform(Function var1);

    public RealmFieldType getFieldType(String fieldName) {
        long columnIndex = this.getColumnIndex(fieldName);
        return this.table.getColumnType(columnIndex);
    }

    abstract FieldDescriptor getColumnIndices(String var1, RealmFieldType ... var2);

    RealmObjectSchema add(String name, RealmFieldType type, boolean primary, boolean indexed, boolean required) {
        long columnIndex = this.table.addColumn(type, name, !required);
        if (indexed) {
            this.table.addSearchIndex(columnIndex);
        }
        if (primary) {
            OsObjectStore.setPrimaryKeyForObject(this.realm.sharedRealm, this.getClassName(), name);
        }
        return this;
    }

    RealmObjectSchema add(String name, RealmFieldType type, RealmObjectSchema linkedTo) {
        this.table.addColumnLink(type, name, this.realm.getSharedRealm().getTable(Table.getTableNameForClass(linkedTo.getClassName())));
        return this;
    }

    long getAndCheckFieldIndex(String fieldName) {
        long index = this.columnInfo.getColumnIndex(fieldName);
        if (index < 0L) {
            throw new IllegalArgumentException("Field does not exist: " + fieldName);
        }
        return index;
    }

    Table getTable() {
        return this.table;
    }

    static final Map<Class<?>, FieldMetaData> getSupportedSimpleFields() {
        return SUPPORTED_SIMPLE_FIELDS;
    }

    protected final SchemaConnector getSchemaConnector() {
        return new SchemaConnector(this.schema);
    }

    long getFieldIndex(String fieldName) {
        return this.columnInfo.getColumnIndex(fieldName);
    }

    static void checkLegalName(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name can not be null or empty");
        }
        if (fieldName.contains(".")) {
            throw new IllegalArgumentException("Field name can not contain '.'");
        }
        if (fieldName.length() > 63) {
            throw new IllegalArgumentException("Field name is currently limited to max 63 characters.");
        }
    }

    void checkFieldExists(String fieldName) {
        if (this.table.getColumnIndex(fieldName) == -1L) {
            throw new IllegalArgumentException("Field name doesn't exist on object '" + this.getClassName() + "': " + fieldName);
        }
    }

    long getColumnIndex(String fieldName) {
        long columnIndex = this.table.getColumnIndex(fieldName);
        if (columnIndex == -1L) {
            throw new IllegalArgumentException(String.format(Locale.US, "Field name '%s' does not exist on schema for '%s'", fieldName, this.getClassName()));
        }
        return columnIndex;
    }

    static {
        HashMap<Class<RealmList>, FieldMetaData> m = new HashMap<Class<RealmList>, FieldMetaData>();
        m.put(String.class, new FieldMetaData(RealmFieldType.STRING, RealmFieldType.STRING_LIST, true));
        m.put(Short.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        m.put(Short.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        m.put(Integer.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        m.put(Integer.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        m.put(Long.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        m.put(Long.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        m.put(Float.TYPE, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_LIST, false));
        m.put(Float.class, new FieldMetaData(RealmFieldType.FLOAT, RealmFieldType.FLOAT_LIST, true));
        m.put(Double.TYPE, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_LIST, false));
        m.put(Double.class, new FieldMetaData(RealmFieldType.DOUBLE, RealmFieldType.DOUBLE_LIST, true));
        m.put(Boolean.TYPE, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_LIST, false));
        m.put(Boolean.class, new FieldMetaData(RealmFieldType.BOOLEAN, RealmFieldType.BOOLEAN_LIST, true));
        m.put(Byte.TYPE, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, false));
        m.put(Byte.class, new FieldMetaData(RealmFieldType.INTEGER, RealmFieldType.INTEGER_LIST, true));
        m.put(byte[].class, new FieldMetaData(RealmFieldType.BINARY, RealmFieldType.BINARY_LIST, true));
        m.put(Date.class, new FieldMetaData(RealmFieldType.DATE, RealmFieldType.DATE_LIST, true));
        SUPPORTED_SIMPLE_FIELDS = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(RealmObject.class, new FieldMetaData(RealmFieldType.OBJECT, null, false));
        m.put(RealmList.class, new FieldMetaData(RealmFieldType.LIST, null, false));
        SUPPORTED_LINKED_FIELDS = Collections.unmodifiableMap(m);
    }

    static final class FieldMetaData {
        final RealmFieldType fieldType;
        final RealmFieldType listType;
        final boolean defaultNullable;

        FieldMetaData(RealmFieldType fieldType, @Nullable RealmFieldType listType, boolean defaultNullable) {
            this.fieldType = fieldType;
            this.listType = listType;
            this.defaultNullable = defaultNullable;
        }
    }

    static final class DynamicColumnIndices
    extends ColumnInfo {
        private final Table table;

        DynamicColumnIndices(Table table) {
            super(null, false);
            this.table = table;
        }

        @Override
        public long getColumnIndex(String columnName) {
            return this.table.getColumnIndex(columnName);
        }

        @Override
        public ColumnInfo.ColumnDetails getColumnDetails(String columnName) {
            throw new UnsupportedOperationException("DynamicColumnIndices do not support 'getColumnDetails'");
        }

        @Override
        public void copyFrom(ColumnInfo src) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot be copied");
        }

        @Override
        protected ColumnInfo copy(boolean immutable) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot be copied");
        }

        @Override
        protected void copy(ColumnInfo src, ColumnInfo dst) {
            throw new UnsupportedOperationException("DynamicColumnIndices cannot copy");
        }
    }

    public static interface Function {
        public void apply(DynamicRealmObject var1);
    }
}

