/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.text.TextUtils;
import io.realm.BaseRealm;
import io.realm.Case;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.SchemaConnector;
import io.realm.Sort;
import io.realm.internal.CheckedRow;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsList;
import io.realm.internal.OsResults;
import io.realm.internal.PendingRow;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.SubscriptionAwareOsResults;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.Util;
import io.realm.internal.annotations.ObjectServer;
import io.realm.internal.core.DescriptorOrdering;
import io.realm.internal.core.IncludeDescriptor;
import io.realm.internal.core.QueryDescriptor;
import io.realm.internal.fields.FieldDescriptor;
import io.realm.internal.sync.SubscriptionAction;
import io.realm.sync.Subscription;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class RealmQuery<E> {
    private final Table table;
    private final BaseRealm realm;
    private final TableQuery query;
    private final RealmObjectSchema schema;
    private Class<E> clazz;
    private String className;
    private final boolean forValues;
    private final OsList osList;
    private DescriptorOrdering queryDescriptors = new DescriptorOrdering();
    private static final String TYPE_MISMATCH = "Field '%s': type mismatch - %s expected.";
    private static final String EMPTY_VALUES = "Non-empty 'values' must be provided.";
    private static final String ASYNC_QUERY_WRONG_THREAD_MESSAGE = "Async query cannot be created on current thread.";

    static <E extends RealmModel> RealmQuery<E> createQuery(Realm realm, Class<E> clazz) {
        return new RealmQuery<E>(realm, clazz);
    }

    static <E extends RealmModel> RealmQuery<E> createDynamicQuery(DynamicRealm realm, String className) {
        return new RealmQuery<E>(realm, className);
    }

    static <E> RealmQuery<E> createQueryFromResult(RealmResults<E> queryResults) {
        return queryResults.classSpec == null ? new RealmQuery<E>(queryResults, queryResults.className) : new RealmQuery<DynamicRealmObject>(queryResults, queryResults.classSpec);
    }

    static <E> RealmQuery<E> createQueryFromList(RealmList<E> list) {
        return list.clazz == null ? new RealmQuery<E>(list.realm, list.getOsList(), list.className) : new RealmQuery(list.realm, list.getOsList(), list.clazz);
    }

    private static boolean isClassForRealmModel(Class<?> clazz) {
        return RealmModel.class.isAssignableFrom(clazz);
    }

    private RealmQuery(Realm realm, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            this.schema = null;
            this.table = null;
            this.osList = null;
            this.query = null;
        } else {
            this.schema = realm.getSchema().getSchemaForClass(clazz);
            this.table = this.schema.getTable();
            this.osList = null;
            this.query = this.table.where();
        }
    }

    private RealmQuery(RealmResults<E> queryResults, Class<E> clazz) {
        this.realm = queryResults.realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            this.schema = null;
            this.table = null;
            this.osList = null;
            this.query = null;
        } else {
            this.schema = this.realm.getSchema().getSchemaForClass(clazz);
            this.table = queryResults.getTable();
            this.osList = null;
            this.query = queryResults.getOsResults().where();
        }
    }

    private RealmQuery(BaseRealm realm, OsList osList, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        boolean bl = this.forValues = !RealmQuery.isClassForRealmModel(clazz);
        if (this.forValues) {
            this.schema = null;
            this.table = null;
            this.osList = null;
            this.query = null;
        } else {
            this.schema = realm.getSchema().getSchemaForClass(clazz);
            this.table = this.schema.getTable();
            this.osList = osList;
            this.query = osList.getQuery();
        }
    }

    private RealmQuery(BaseRealm realm, String className) {
        this.realm = realm;
        this.className = className;
        this.forValues = false;
        this.schema = realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = this.table.where();
        this.osList = null;
    }

    private RealmQuery(RealmResults<DynamicRealmObject> queryResults, String className) {
        this.realm = queryResults.realm;
        this.className = className;
        this.forValues = false;
        this.schema = this.realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = queryResults.getOsResults().where();
        this.osList = null;
    }

    private RealmQuery(BaseRealm realm, OsList osList, String className) {
        this.realm = realm;
        this.className = className;
        this.forValues = false;
        this.schema = realm.getSchema().getSchemaForClass(className);
        this.table = this.schema.getTable();
        this.query = osList.getQuery();
        this.osList = osList;
    }

    public boolean isValid() {
        if (this.realm == null || this.realm.isClosed()) {
            return false;
        }
        if (this.osList != null) {
            return this.osList.isValid();
        }
        return this.table != null && this.table.isValid();
    }

    public RealmQuery<E> isNull(String fieldName) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, new RealmFieldType[0]);
        this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        return this;
    }

    public RealmQuery<E> isNotNull(String fieldName) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, new RealmFieldType[0]);
        this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable String value) {
        return this.equalTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable String value, Case casing) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value, casing);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable String value, Case casing) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Byte value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Byte value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable byte[] value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.BINARY);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Short value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Short value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Integer value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Integer value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.intValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Long value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Long value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Double value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Double value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Float value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Float value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Boolean value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Boolean value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.BOOLEAN);
        if (value == null) {
            this.query.isNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, @Nullable Date value) {
        this.realm.checkIfValid();
        return this.equalToWithoutThreadValidation(fieldName, value);
    }

    private RealmQuery<E> equalToWithoutThreadValidation(String fieldName, @Nullable Date value) {
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> in(String fieldName, @Nullable String[] values) {
        return this.in(fieldName, values, Case.SENSITIVE);
    }

    public RealmQuery<E> in(String fieldName, @Nullable String[] values, Case casing) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0], casing);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i], casing);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Byte[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Short[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Integer[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Long[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Double[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Float[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Boolean[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> in(String fieldName, @Nullable Date[] values) {
        this.realm.checkIfValid();
        if (values == null || values.length == 0) {
            this.alwaysFalse();
            return this;
        }
        super.equalToWithoutThreadValidation(fieldName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            super.equalToWithoutThreadValidation(fieldName, values[i]);
        }
        return this.endGroupWithoutThreadValidation();
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable String value) {
        return this.notEqualTo(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable String value, Case casing) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        if (fd.length() > 1 && !casing.getValue()) {
            throw new IllegalArgumentException("Link queries cannot be case insensitive - coming soon.");
        }
        this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Byte value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.byteValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable byte[] value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.BINARY);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Short value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.shortValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Integer value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.intValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Long value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Double value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Float value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value.floatValue());
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Boolean value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.BOOLEAN);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.equalTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value == false);
        }
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, @Nullable Date value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        if (value == null) {
            this.query.isNotNull(fd.getColumnIndices(), fd.getNativeTablePointers());
        } else {
            this.query.notEqualTo(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        }
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, int value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, long value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, double value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.greaterThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, float value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.greaterThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Date value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.greaterThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, int value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, long value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.greaterThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, double value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.greaterThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, float value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.greaterThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Date value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.greaterThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, int value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, long value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, double value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.lessThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, float value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.lessThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Date value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.lessThan(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, int value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, long value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.lessThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, double value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.lessThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, float value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.lessThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Date value) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.lessThanOrEqual(fd.getColumnIndices(), fd.getNativeTablePointers(), value);
        return this;
    }

    public RealmQuery<E> between(String fieldName, int from, int to) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.between(fd.getColumnIndices(), from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, long from, long to) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.INTEGER);
        this.query.between(fd.getColumnIndices(), from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, double from, double to) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DOUBLE);
        this.query.between(fd.getColumnIndices(), from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, float from, float to) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.FLOAT);
        this.query.between(fd.getColumnIndices(), from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, Date from, Date to) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.DATE);
        this.query.between(fd.getColumnIndices(), from, to);
        return this;
    }

    public RealmQuery<E> contains(String fieldName, String value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> contains(String fieldName, String value, Case casing) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.contains(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, String value) {
        return this.beginsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> beginsWith(String fieldName, String value, Case casing) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.beginsWith(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> endsWith(String fieldName, String value, Case casing) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.endsWith(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> like(String fieldName, String value) {
        return this.like(fieldName, value, Case.SENSITIVE);
    }

    public RealmQuery<E> like(String fieldName, String value, Case casing) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING);
        this.query.like(fd.getColumnIndices(), fd.getNativeTablePointers(), value, casing);
        return this;
    }

    public RealmQuery<E> beginGroup() {
        this.realm.checkIfValid();
        return this.beginGroupWithoutThreadValidation();
    }

    private RealmQuery<E> beginGroupWithoutThreadValidation() {
        this.query.group();
        return this;
    }

    public RealmQuery<E> endGroup() {
        this.realm.checkIfValid();
        return this.endGroupWithoutThreadValidation();
    }

    private RealmQuery<E> endGroupWithoutThreadValidation() {
        this.query.endGroup();
        return this;
    }

    public RealmQuery<E> or() {
        this.realm.checkIfValid();
        return this.orWithoutThreadValidation();
    }

    private RealmQuery<E> orWithoutThreadValidation() {
        this.query.or();
        return this;
    }

    public RealmQuery<E> and() {
        this.realm.checkIfValid();
        return this;
    }

    public RealmQuery<E> not() {
        this.realm.checkIfValid();
        this.query.not();
        return this;
    }

    public RealmQuery<E> isEmpty(String fieldName) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING, RealmFieldType.BINARY, RealmFieldType.LIST, RealmFieldType.LINKING_OBJECTS);
        this.query.isEmpty(fd.getColumnIndices(), fd.getNativeTablePointers());
        return this;
    }

    public RealmQuery<E> isNotEmpty(String fieldName) {
        this.realm.checkIfValid();
        FieldDescriptor fd = this.schema.getColumnIndices(fieldName, RealmFieldType.STRING, RealmFieldType.BINARY, RealmFieldType.LIST, RealmFieldType.LINKING_OBJECTS);
        this.query.isNotEmpty(fd.getColumnIndices(), fd.getNativeTablePointers());
        return this;
    }

    public Number sum(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.sumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.sumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.sumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    public double average(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.averageInt(columnIndex);
            }
            case DOUBLE: {
                return this.query.averageDouble(columnIndex);
            }
            case FLOAT: {
                return this.query.averageFloat(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Nullable
    public Number min(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.minimumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.minimumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.minimumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Nullable
    public Date minimumDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        return this.query.minimumDate(columnIndex);
    }

    @Nullable
    public Number max(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        switch (this.table.getColumnType(columnIndex)) {
            case INTEGER: {
                return this.query.maximumInt(columnIndex);
            }
            case FLOAT: {
                return this.query.maximumFloat(columnIndex);
            }
            case DOUBLE: {
                return this.query.maximumDouble(columnIndex);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, TYPE_MISMATCH, fieldName, "int, float or double"));
    }

    @Nullable
    public Date maximumDate(String fieldName) {
        this.realm.checkIfValid();
        long columnIndex = this.schema.getAndCheckFieldIndex(fieldName);
        return this.query.maximumDate(columnIndex);
    }

    public long count() {
        this.realm.checkIfValid();
        return this.lazyFindAll().size();
    }

    public RealmResults<E> findAll() {
        this.realm.checkIfValid();
        return this.createRealmResults(this.query, this.queryDescriptors, true, SubscriptionAction.NO_SUBSCRIPTION);
    }

    private OsResults lazyFindAll() {
        this.realm.checkIfValid();
        return this.createRealmResults((TableQuery)this.query, (DescriptorOrdering)this.queryDescriptors, (boolean)false, (SubscriptionAction)SubscriptionAction.NO_SUBSCRIPTION).osResults;
    }

    public RealmResults<E> findAllAsync() {
        this.realm.checkIfValid();
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification(ASYNC_QUERY_WRONG_THREAD_MESSAGE);
        SubscriptionAction subscriptionAction = this.realm.sharedRealm.isPartial() && this.osList == null ? SubscriptionAction.ANONYMOUS_SUBSCRIPTION : SubscriptionAction.NO_SUBSCRIPTION;
        return this.createRealmResults(this.query, this.queryDescriptors, false, subscriptionAction);
    }

    @ObjectServer
    public RealmResults<E> findAllAsync(String subscriptionName) {
        return this.findAllAsync(subscriptionName, Long.MAX_VALUE, TimeUnit.MILLISECONDS, false);
    }

    @ObjectServer
    public RealmResults<E> findAllAsync(String subscriptionName, boolean update) {
        return this.findAllAsync(subscriptionName, Long.MAX_VALUE, TimeUnit.MILLISECONDS, update);
    }

    @ObjectServer
    public RealmResults<E> findAllAsync(String subscriptionName, long timeToLive, TimeUnit timeUnit) {
        return this.findAllAsync(subscriptionName, timeToLive, timeUnit, false);
    }

    @ObjectServer
    public RealmResults<E> findAllAsync(String subscriptionName, long timeToLive, TimeUnit timeUnit, boolean update) {
        this.realm.checkIfValid();
        this.realm.checkIfPartialRealm();
        if (this.osList != null) {
            throw new IllegalStateException("Cannot create subscriptions for queries based on a 'RealmList'");
        }
        if (Util.isEmptyString(subscriptionName)) {
            throw new IllegalArgumentException("Non-empty 'subscriptionName' required.");
        }
        if (timeToLive < 0L) {
            throw new IllegalArgumentException("Negative values for 'timeToLive' are not allowed: " + timeToLive);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Non-null 'timeUnit' required.");
        }
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification(ASYNC_QUERY_WRONG_THREAD_MESSAGE);
        long timeToLiveMs = timeUnit.toMillis(timeToLive);
        SubscriptionAction action = update ? SubscriptionAction.update(subscriptionName, timeToLiveMs) : SubscriptionAction.create(subscriptionName, timeToLiveMs);
        return this.createRealmResults(this.query, this.queryDescriptors, false, action);
    }

    public RealmQuery<E> sort(String fieldName) {
        this.realm.checkIfValid();
        return this.sort(fieldName, Sort.ASCENDING);
    }

    public RealmQuery<E> sort(String fieldName, Sort sortOrder) {
        this.realm.checkIfValid();
        return this.sort(new String[]{fieldName}, new Sort[]{sortOrder});
    }

    public RealmQuery<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        this.realm.checkIfValid();
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    public RealmQuery<E> sort(String[] fieldNames, Sort[] sortOrders) {
        this.realm.checkIfValid();
        QueryDescriptor sortDescriptor = QueryDescriptor.getInstanceForSort((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.query.getTable(), fieldNames, sortOrders);
        this.queryDescriptors.appendSort(sortDescriptor);
        return this;
    }

    public RealmQuery<E> distinct(String fieldName) {
        return this.distinct(fieldName, new String[0]);
    }

    public RealmQuery<E> distinct(String firstFieldName, String ... remainingFieldNames) {
        QueryDescriptor distinctDescriptor;
        this.realm.checkIfValid();
        if (remainingFieldNames.length == 0) {
            distinctDescriptor = QueryDescriptor.getInstanceForDistinct((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.table, firstFieldName);
        } else {
            String[] fieldNames = new String[1 + remainingFieldNames.length];
            fieldNames[0] = firstFieldName;
            System.arraycopy(remainingFieldNames, 0, fieldNames, 1, remainingFieldNames.length);
            distinctDescriptor = QueryDescriptor.getInstanceForDistinct((FieldDescriptor.SchemaProxy)this.getSchemaConnector(), this.table, fieldNames);
        }
        this.queryDescriptors.appendDistinct(distinctDescriptor);
        return this;
    }

    public RealmQuery<E> limit(long limit) {
        this.realm.checkIfValid();
        if (limit < 1L) {
            throw new IllegalArgumentException("Only positive numbers above 0 is allowed. Yours was: " + limit);
        }
        this.queryDescriptors.setLimit(limit);
        return this;
    }

    @ObjectServer
    public RealmQuery<E> includeLinkingObjects(String firstIncludePath, String ... remainingFieldPaths) {
        this.realm.checkIfValid();
        if (!ObjectServerFacade.getSyncFacadeIfPossible().isPartialRealm(this.realm.getConfiguration())) {
            throw new IllegalStateException("This method is only available for Query-based Realms.");
        }
        if (Util.isEmptyString(firstIncludePath)) {
            throw new IllegalArgumentException("Non-empty 'firstIncludePath' required.");
        }
        this.queryDescriptors.appendIncludes(IncludeDescriptor.createInstance(this.getSchemaConnector(), this.table, firstIncludePath));
        if (remainingFieldPaths != null) {
            for (int i = 0; i < remainingFieldPaths.length; ++i) {
                this.queryDescriptors.appendIncludes(IncludeDescriptor.createInstance(this.getSchemaConnector(), this.table, remainingFieldPaths[i]));
            }
        }
        return this;
    }

    public RealmQuery<E> alwaysTrue() {
        this.realm.checkIfValid();
        this.query.alwaysTrue();
        return this;
    }

    public RealmQuery<E> alwaysFalse() {
        this.realm.checkIfValid();
        this.query.alwaysFalse();
        return this;
    }

    public Realm getRealm() {
        if (this.realm == null) {
            return null;
        }
        this.realm.checkIfValid();
        if (!(this.realm instanceof Realm)) {
            throw new IllegalStateException("This method is only available for typed Realms");
        }
        return (Realm)this.realm;
    }

    @ObjectServer
    public Subscription subscribe() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.table != null ? this.table.getClassName() : "");
        sb.append("] ");
        sb.append(RealmQuery.nativeSerializeQuery(this.query.getNativePtr(), this.queryDescriptors.getNativePtr()));
        String name = sb.toString();
        return this.subscribe(name);
    }

    @ObjectServer
    public Subscription subscribe(String name) {
        return this.subscribe(name, Long.MAX_VALUE, TimeUnit.MILLISECONDS, false);
    }

    @ObjectServer
    public Subscription subscribe(String name, long timeToLive, TimeUnit timeUnit) {
        return this.subscribe(name, timeToLive, timeUnit, false);
    }

    @ObjectServer
    public Subscription subscribeOrUpdate(String name) {
        return this.subscribe(name, Long.MAX_VALUE, TimeUnit.MILLISECONDS, true);
    }

    @ObjectServer
    public Subscription subscribeOrUpdate(String name, long timeToLive, TimeUnit timeUnit) {
        return this.subscribe(name, timeToLive, timeUnit, true);
    }

    @ObjectServer
    private Subscription subscribe(String name, long timeToLive, TimeUnit timeUnit, boolean update) {
        this.realm.checkIfValid();
        if (this.realm instanceof DynamicRealm) {
            throw new IllegalStateException("'subscribe' is not supported for queries on Dynamic Realms.");
        }
        if (this.osList != null) {
            throw new IllegalStateException("Cannot create subscriptions for queries based on a 'RealmList. Subscribe to the object holding the list instead.'");
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Non-empty 'name' required.");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Non-null 'timeUnit' is required.");
        }
        long timeToLiveMs = TimeUnit.MILLISECONDS.convert(timeToLive, timeUnit);
        long rowIndex = RealmQuery.nativeSubscribe(this.realm.getSharedRealm().getNativePtr(), name, this.query.getNativePtr(), this.queryDescriptors.getNativePtr(), timeToLiveMs, update);
        CheckedRow row = ((Realm)this.realm).getTable(Subscription.class).getCheckedRow(rowIndex);
        return this.realm.get(Subscription.class, null, row);
    }

    public String getDescription() {
        return RealmQuery.nativeSerializeQuery(this.query.getNativePtr(), this.queryDescriptors.getNativePtr());
    }

    public String getTypeQueried() {
        return this.table.getClassName();
    }

    private boolean isDynamicQuery() {
        return this.className != null;
    }

    @Nullable
    public E findFirst() {
        this.realm.checkIfValid();
        if (this.forValues) {
            return null;
        }
        long tableRowIndex = this.getSourceRowIndexForFirstObject();
        return tableRowIndex < 0L ? null : (E)this.realm.get(this.clazz, this.className, tableRowIndex);
    }

    public E findFirstAsync() {
        DynamicRealmObject result;
        this.realm.checkIfValid();
        if (this.forValues) {
            throw new UnsupportedOperationException("findFirstAsync() available only when type parameter 'E' is implementing RealmModel.");
        }
        this.realm.sharedRealm.capabilities.checkCanDeliverNotification(ASYNC_QUERY_WRONG_THREAD_MESSAGE);
        Row row = this.realm.isInTransaction() ? OsResults.createFromQuery(this.realm.sharedRealm, this.query).firstUncheckedRow() : new PendingRow(this.realm.sharedRealm, this.query, this.queryDescriptors, this.isDynamicQuery());
        if (this.isDynamicQuery()) {
            result = new DynamicRealmObject(this.realm, row);
        } else {
            Class<E> modelClass = this.clazz;
            result = this.realm.getConfiguration().getSchemaMediator().newInstance(modelClass, this.realm, row, this.realm.getSchema().getColumnInfo(modelClass), false, Collections.emptyList());
        }
        if (row instanceof PendingRow) {
            RealmObjectProxy proxy = result;
            ((PendingRow)row).setFrontEnd(proxy.realmGet$proxyState());
        }
        return (E)result;
    }

    private RealmResults<E> createRealmResults(TableQuery query, DescriptorOrdering queryDescriptors, boolean loadResults, SubscriptionAction subscriptionAction) {
        OsResults osResults = subscriptionAction.shouldCreateSubscriptions() ? SubscriptionAwareOsResults.createFromQuery(this.realm.sharedRealm, query, queryDescriptors, subscriptionAction) : OsResults.createFromQuery(this.realm.sharedRealm, query, queryDescriptors);
        RealmResults results = this.isDynamicQuery() ? new RealmResults(this.realm, osResults, this.className) : new RealmResults<E>(this.realm, osResults, this.clazz);
        if (loadResults) {
            results.load();
        }
        return results;
    }

    private long getSourceRowIndexForFirstObject() {
        if (!this.queryDescriptors.isEmpty()) {
            RealmObjectProxy obj = (RealmObjectProxy)this.findAll().first((Object)null);
            if (obj != null) {
                return obj.realmGet$proxyState().getRow$realm().getIndex();
            }
            return -1L;
        }
        return this.query.find();
    }

    private SchemaConnector getSchemaConnector() {
        return new SchemaConnector(this.realm.getSchema());
    }

    private static native String nativeSerializeQuery(long var0, long var2);

    private static native long nativeSubscribe(long var0, String var2, long var3, long var5, long var7, boolean var9);
}

