/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import io.reactivex.annotations.Beta;
import io.realm.BaseRealm;
import io.realm.ClientResyncMode;
import io.realm.CompactOnLaunchCallback;
import io.realm.DefaultCompactOnLaunchCallback;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.SyncManager;
import io.realm.SyncSession;
import io.realm.SyncUser;
import io.realm.annotations.RealmModule;
import io.realm.exceptions.RealmException;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Util;
import io.realm.internal.sync.permissions.ObjectPermissionsModule;
import io.realm.log.RealmLog;
import io.realm.rx.RealmObservableFactory;
import io.realm.rx.RxObservableFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SyncConfiguration
extends RealmConfiguration {
    static final int MAX_FULL_PATH_LENGTH = 256;
    static final int MAX_FILE_NAME_LENGTH = 255;
    private static final char[] INVALID_CHARS = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
    private final URI serverUrl;
    private final SyncUser user;
    private final SyncSession.ErrorHandler errorHandler;
    private final boolean deleteRealmOnLogout;
    private final boolean syncClientValidateSsl;
    @Nullable
    private final String serverCertificateAssetName;
    @Nullable
    private final String serverCertificateFilePath;
    private final boolean waitForInitialData;
    private final long initialDataTimeoutMillis;
    private final OsRealmConfig.SyncSessionStopPolicy sessionStopPolicy;
    private final boolean isPartial;
    @Nullable
    private final String syncUrlPrefix;
    private final ClientResyncMode clientResyncMode;

    private SyncConfiguration(File directory, String filename, String canonicalPath, @Nullable String assetFilePath, @Nullable byte[] key, long schemaVersion, @Nullable RealmMigration migration, boolean deleteRealmIfMigrationNeeded, OsRealmConfig.Durability durability, RealmProxyMediator schemaMediator, @Nullable RxObservableFactory rxFactory, @Nullable Realm.Transaction initialDataTransaction, boolean readOnly, SyncUser user, URI serverUrl, SyncSession.ErrorHandler errorHandler, boolean deleteRealmOnLogout, boolean syncClientValidateSsl, @Nullable String serverCertificateAssetName, @Nullable String serverCertificateFilePath, boolean waitForInitialData, long initialDataTimeoutMillis, OsRealmConfig.SyncSessionStopPolicy sessionStopPolicy, boolean isPartial, CompactOnLaunchCallback compactOnLaunch, @Nullable String syncUrlPrefix, ClientResyncMode clientResyncMode) {
        super(directory, filename, canonicalPath, assetFilePath, key, schemaVersion, migration, deleteRealmIfMigrationNeeded, durability, schemaMediator, rxFactory, initialDataTransaction, readOnly, compactOnLaunch, false);
        this.user = user;
        this.serverUrl = serverUrl;
        this.errorHandler = errorHandler;
        this.deleteRealmOnLogout = deleteRealmOnLogout;
        this.syncClientValidateSsl = syncClientValidateSsl;
        this.serverCertificateAssetName = serverCertificateAssetName;
        this.serverCertificateFilePath = serverCertificateFilePath;
        this.waitForInitialData = waitForInitialData;
        this.initialDataTimeoutMillis = initialDataTimeoutMillis;
        this.sessionStopPolicy = sessionStopPolicy;
        this.isPartial = isPartial;
        this.syncUrlPrefix = syncUrlPrefix;
        this.clientResyncMode = clientResyncMode;
    }

    public static RealmConfiguration forRecovery(String canonicalPath, @Nullable byte[] encryptionKey, Object ... modules) {
        HashSet<Object> validatedModules = new HashSet<Object>();
        if (modules != null && modules.length > 0) {
            for (Object module : modules) {
                if (!module.getClass().isAnnotationPresent(RealmModule.class)) {
                    throw new IllegalArgumentException(module.getClass().getCanonicalName() + " is not a RealmModule. Add @RealmModule to the class definition.");
                }
                validatedModules.add(module);
            }
        } else if (Realm.getDefaultModule() != null) {
            validatedModules.add(Realm.getDefaultModule());
        }
        RealmProxyMediator schemaMediator = SyncConfiguration.createSchemaMediator(validatedModules, Collections.emptySet());
        return SyncConfiguration.forRecovery(canonicalPath, encryptionKey, schemaMediator);
    }

    public static RealmConfiguration forRecovery(String canonicalPath) {
        return SyncConfiguration.forRecovery(canonicalPath, null, new Object[0]);
    }

    static RealmConfiguration forRecovery(String canonicalPath, @Nullable byte[] encryptionKey, RealmProxyMediator schemaMediator) {
        return new RealmConfiguration(null, null, canonicalPath, null, encryptionKey, 0L, null, false, OsRealmConfig.Durability.FULL, schemaMediator, null, null, true, null, true);
    }

    static URI resolveServerUrl(URI serverUrl, String userIdentifier) {
        try {
            return new URI(serverUrl.toString().replace("/~/", "/" + userIdentifier + "/"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not replace '/~/' with a valid user ID.", e);
        }
    }

    @Deprecated
    @Beta
    public static SyncConfiguration automatic() {
        SyncUser user = SyncUser.current();
        if (user == null) {
            throw new IllegalStateException("No user was logged in.");
        }
        return user.getDefaultConfiguration();
    }

    @Deprecated
    @Beta
    public static SyncConfiguration automatic(SyncUser user) {
        if (user == null) {
            throw new IllegalArgumentException("Non-null 'user' required.");
        }
        if (!user.isValid()) {
            throw new IllegalArgumentException("User is no logger valid.  Log the user in again.");
        }
        return user.getDefaultConfiguration();
    }

    private static String getServerPath(URI serverUrl) {
        String path = serverUrl.getPath();
        int endIndex = path.lastIndexOf("/");
        if (endIndex == -1) {
            return path;
        }
        if (endIndex == 0) {
            return path.substring(1);
        }
        return path.substring(1, endIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SyncConfiguration that = (SyncConfiguration)o;
        if (this.deleteRealmOnLogout != that.deleteRealmOnLogout) {
            return false;
        }
        if (this.syncClientValidateSsl != that.syncClientValidateSsl) {
            return false;
        }
        if (this.waitForInitialData != that.waitForInitialData) {
            return false;
        }
        if (this.initialDataTimeoutMillis != that.initialDataTimeoutMillis) {
            return false;
        }
        if (this.isPartial != that.isPartial) {
            return false;
        }
        if (!this.serverUrl.equals(that.serverUrl)) {
            return false;
        }
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.errorHandler.equals(that.errorHandler)) {
            return false;
        }
        if (this.serverCertificateAssetName != null ? !this.serverCertificateAssetName.equals(that.serverCertificateAssetName) : that.serverCertificateAssetName != null) {
            return false;
        }
        if (this.serverCertificateFilePath != null ? !this.serverCertificateFilePath.equals(that.serverCertificateFilePath) : that.serverCertificateFilePath != null) {
            return false;
        }
        if (this.sessionStopPolicy != that.sessionStopPolicy) {
            return false;
        }
        if (this.syncUrlPrefix != null ? !this.syncUrlPrefix.equals(that.syncUrlPrefix) : that.syncUrlPrefix != null) {
            return false;
        }
        return this.clientResyncMode == that.clientResyncMode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serverUrl.hashCode();
        result = 31 * result + this.user.hashCode();
        result = 31 * result + this.errorHandler.hashCode();
        result = 31 * result + (this.deleteRealmOnLogout ? 1 : 0);
        result = 31 * result + (this.syncClientValidateSsl ? 1 : 0);
        result = 31 * result + (this.serverCertificateAssetName != null ? this.serverCertificateAssetName.hashCode() : 0);
        result = 31 * result + (this.serverCertificateFilePath != null ? this.serverCertificateFilePath.hashCode() : 0);
        result = 31 * result + (this.waitForInitialData ? 1 : 0);
        result = 31 * result + (int)(this.initialDataTimeoutMillis ^ this.initialDataTimeoutMillis >>> 32);
        result = 31 * result + this.sessionStopPolicy.hashCode();
        result = 31 * result + (this.isPartial ? 1 : 0);
        result = 31 * result + (this.syncUrlPrefix != null ? this.syncUrlPrefix.hashCode() : 0);
        result = 31 * result + this.clientResyncMode.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n");
        sb.append("serverUrl: ").append(this.serverUrl);
        sb.append("\n");
        sb.append("user: ").append(this.user);
        sb.append("\n");
        sb.append("errorHandler: ").append(this.errorHandler);
        sb.append("\n");
        sb.append("deleteRealmOnLogout: ").append(this.deleteRealmOnLogout);
        sb.append("\n");
        sb.append("syncClientValidateSsl: ").append(this.syncClientValidateSsl);
        sb.append("\n");
        sb.append("serverCertificateAssetName: ").append(this.serverCertificateAssetName);
        sb.append("\n");
        sb.append("serverCertificateFilePath: ").append(this.serverCertificateFilePath);
        sb.append("\n");
        sb.append("waitForInitialData: ").append(this.waitForInitialData);
        sb.append("\n");
        sb.append("initialDataTimeoutMillis: ").append(this.initialDataTimeoutMillis);
        sb.append("\n");
        sb.append("sessionStopPolicy: ").append((Object)this.sessionStopPolicy);
        sb.append("\n");
        sb.append("isPartial: ").append(this.isPartial);
        sb.append("\n");
        sb.append("syncUrlPrefix: ").append(this.syncUrlPrefix);
        sb.append("\n");
        sb.append("clientResyncMode: ").append((Object)this.clientResyncMode);
        return sb.toString();
    }

    public SyncUser getUser() {
        return this.user;
    }

    public URI getServerUrl() {
        return this.serverUrl;
    }

    public SyncSession.ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean shouldDeleteRealmOnLogout() {
        return this.deleteRealmOnLogout;
    }

    @Nullable
    public String getServerCertificateAssetName() {
        return this.serverCertificateAssetName;
    }

    @Nullable
    public String getServerCertificateFilePath() {
        return this.serverCertificateFilePath;
    }

    public boolean syncClientValidateSsl() {
        return this.syncClientValidateSsl;
    }

    public boolean shouldWaitForInitialRemoteData() {
        return this.waitForInitialData;
    }

    public long getInitialRemoteDataTimeout(TimeUnit unit) {
        return unit.convert(this.initialDataTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    boolean isSyncConfiguration() {
        return true;
    }

    public OsRealmConfig.SyncSessionStopPolicy getSessionStopPolicy() {
        return this.sessionStopPolicy;
    }

    @Deprecated
    public boolean isPartialRealm() {
        return this.isPartial;
    }

    public boolean isFullySynchronizedRealm() {
        return !this.isPartial;
    }

    @Nullable
    public String getUrlPrefix() {
        return this.syncUrlPrefix;
    }

    public ClientResyncMode getClientResyncMode() {
        return this.clientResyncMode;
    }

    public static final class Builder {
        private File directory;
        private boolean overrideDefaultFolder = false;
        private String fileName;
        private boolean overrideDefaultLocalFileName = false;
        @Nullable
        private byte[] key;
        private long schemaVersion = 0L;
        private HashSet<Object> modules = new HashSet();
        private HashSet<Class<? extends RealmModel>> debugSchema = new HashSet();
        @Nullable
        private RxObservableFactory rxFactory;
        @Nullable
        private Realm.Transaction initialDataTransaction;
        private File defaultFolder;
        private String defaultLocalFileName;
        private OsRealmConfig.Durability durability = OsRealmConfig.Durability.FULL;
        private final Pattern pattern = Pattern.compile("^[A-Za-z0-9_\\-\\.]+$");
        private boolean readOnly = false;
        private boolean waitForServerChanges = false;
        private long initialDataTimeoutMillis = Long.MAX_VALUE;
        private boolean deleteRealmOnLogout = false;
        private URI serverUrl;
        private SyncUser user = null;
        private SyncSession.ErrorHandler errorHandler = SyncManager.defaultSessionErrorHandler;
        private boolean syncClientValidateSsl = true;
        @Nullable
        private String serverCertificateAssetName;
        @Nullable
        private String serverCertificateFilePath;
        private OsRealmConfig.SyncSessionStopPolicy sessionStopPolicy = OsRealmConfig.SyncSessionStopPolicy.AFTER_CHANGES_UPLOADED;
        private boolean isPartial = true;
        private CompactOnLaunchCallback compactOnLaunch;
        private String syncUrlPrefix = null;
        @Nullable
        private ClientResyncMode clientResyncMode = null;

        @Deprecated
        public Builder(SyncUser user, String uri) {
            this(BaseRealm.applicationContext, user, uri);
            this.fullSynchronization();
        }

        Builder(Context context, SyncUser user, String url) {
            if (context == null) {
                throw new IllegalStateException("Call `Realm.init(Context)` before creating a SyncConfiguration");
            }
            this.defaultFolder = new File(context.getFilesDir(), "realm-object-server");
            if (Realm.getDefaultModule() != null) {
                this.modules.add(Realm.getDefaultModule());
            }
            this.validateAndSet(user);
            this.validateAndSet(url);
        }

        private void validateAndSet(SyncUser user) {
            if (user == null) {
                throw new IllegalArgumentException("Non-null `user` required.");
            }
            if (!user.isValid()) {
                throw new IllegalArgumentException("User not authenticated or authentication expired.");
            }
            this.user = user;
        }

        private void validateAndSet(String uri) {
            if (uri == null) {
                throw new IllegalArgumentException("Non-null 'uri' required.");
            }
            try {
                this.serverUrl = new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI: " + uri, e);
            }
            try {
                String path;
                String serverScheme = this.serverUrl.getScheme();
                if (serverScheme == null) {
                    String authProtocol = this.user.getAuthenticationUrl().getProtocol();
                    serverScheme = authProtocol.equalsIgnoreCase("https") ? "realms" : "realm";
                } else if (serverScheme.equalsIgnoreCase("http")) {
                    serverScheme = "realm";
                } else if (serverScheme.equalsIgnoreCase("https")) {
                    serverScheme = "realms";
                }
                String host = this.serverUrl.getHost();
                if (host == null) {
                    host = this.user.getAuthenticationUrl().getHost();
                }
                if ((path = this.serverUrl.getPath()) != null && !path.startsWith("/")) {
                    path = "/" + path;
                }
                this.serverUrl = new URI(serverScheme, this.serverUrl.getUserInfo(), host, this.serverUrl.getPort(), path != null ? path.replace(host + "/", "") : null, this.serverUrl.getQuery(), this.serverUrl.getRawFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI: " + uri, e);
            }
            String path = this.serverUrl.getPath();
            if (path == null) {
                throw new IllegalArgumentException("Invalid URI: " + uri);
            }
            String[] pathSegments = path.split("/");
            for (int i = 1; i < pathSegments.length; ++i) {
                String segment = pathSegments[i];
                if (segment.equals("~")) continue;
                if (segment.equals("..") || segment.equals(".")) {
                    throw new IllegalArgumentException("The URI has an invalid segment: " + segment);
                }
                Matcher m = this.pattern.matcher(segment);
                if (m.matches()) continue;
                throw new IllegalArgumentException("The URI must only contain characters 0-9, a-z, A-Z, ., _, and -: " + segment);
            }
            this.defaultLocalFileName = pathSegments[pathSegments.length - 1];
            if (this.defaultLocalFileName.endsWith(".realm") || this.defaultLocalFileName.endsWith(".realm.lock") || this.defaultLocalFileName.endsWith(".realm.management")) {
                throw new IllegalArgumentException("The URI must not end with '.realm', '.realm.lock' or '.realm.management: " + uri);
            }
        }

        public Builder name(String filename) {
            if (filename == null || filename.isEmpty()) {
                throw new IllegalArgumentException("A non-empty filename must be provided");
            }
            this.fileName = filename;
            this.overrideDefaultLocalFileName = true;
            return this;
        }

        public Builder directory(File directory) {
            if (directory == null) {
                throw new IllegalArgumentException("Non-null 'directory' required.");
            }
            if (directory.isFile()) {
                throw new IllegalArgumentException("'directory' is a file, not a directory: " + directory.getAbsolutePath() + ".");
            }
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IllegalArgumentException("Could not create the specified directory: " + directory.getAbsolutePath() + ".");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException("Realm directory is not writable: " + directory.getAbsolutePath() + ".");
            }
            this.directory = directory;
            this.overrideDefaultFolder = true;
            return this;
        }

        public Builder encryptionKey(byte[] key) {
            if (key == null) {
                throw new IllegalArgumentException("A non-null key must be provided");
            }
            if (key.length != 64) {
                throw new IllegalArgumentException(String.format(Locale.US, "The provided key must be %s bytes. Yours was: %s", 64, key.length));
            }
            this.key = Arrays.copyOf(key, key.length);
            return this;
        }

        Builder schema(Class<? extends RealmModel> firstClass, Class<? extends RealmModel> ... additionalClasses) {
            if (firstClass == null) {
                throw new IllegalArgumentException("A non-null class must be provided");
            }
            this.modules.clear();
            this.modules.add(RealmConfiguration.DEFAULT_MODULE_MEDIATOR);
            this.debugSchema.add(firstClass);
            if (additionalClasses != null) {
                Collections.addAll(this.debugSchema, additionalClasses);
            }
            return this;
        }

        Builder sessionStopPolicy(OsRealmConfig.SyncSessionStopPolicy policy) {
            this.sessionStopPolicy = policy;
            return this;
        }

        public Builder schemaVersion(long schemaVersion) {
            if (schemaVersion < 0L) {
                throw new IllegalArgumentException("Realm schema version numbers must be 0 (zero) or higher. Yours was: " + schemaVersion);
            }
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder modules(Object baseModule, Object ... additionalModules) {
            this.modules.clear();
            this.addModule(baseModule);
            if (additionalModules != null) {
                for (Object module : additionalModules) {
                    this.addModule(module);
                }
            }
            return this;
        }

        public Builder modules(Iterable<Object> modules) {
            this.modules.clear();
            if (modules != null) {
                for (Object module : modules) {
                    this.addModule(module);
                }
            }
            return this;
        }

        public Builder addModule(Object module) {
            if (module != null) {
                this.checkModule(module);
                this.modules.add(module);
            }
            return this;
        }

        public Builder rxFactory(RxObservableFactory factory) {
            this.rxFactory = factory;
            return this;
        }

        public Builder initialData(Realm.Transaction transaction) {
            this.initialDataTransaction = transaction;
            return this;
        }

        public Builder inMemory() {
            this.durability = OsRealmConfig.Durability.MEM_ONLY;
            return this;
        }

        public Builder errorHandler(SyncSession.ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new IllegalArgumentException("Non-null 'errorHandler' required.");
            }
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder trustedRootCA(String filename) {
            if (filename == null || filename.isEmpty()) {
                throw new IllegalArgumentException("A non-empty filename must be provided");
            }
            this.serverCertificateAssetName = filename;
            return this;
        }

        public Builder disableSSLVerification() {
            this.syncClientValidateSsl = false;
            return this;
        }

        public Builder waitForInitialRemoteData() {
            this.waitForServerChanges = true;
            this.initialDataTimeoutMillis = Long.MAX_VALUE;
            return this;
        }

        public Builder waitForInitialRemoteData(long timeout, TimeUnit unit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("'timeout' must be >= 0. It was: " + timeout);
            }
            if (unit == null) {
                throw new IllegalArgumentException("Non-null 'unit' required");
            }
            this.waitForServerChanges = true;
            this.initialDataTimeoutMillis = unit.toMillis(timeout);
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        @Deprecated
        public Builder partialRealm() {
            this.isPartial = true;
            return this;
        }

        public Builder fullSynchronization() {
            this.isPartial = false;
            return this;
        }

        public Builder compactOnLaunch() {
            return this.compactOnLaunch(new DefaultCompactOnLaunchCallback());
        }

        public Builder compactOnLaunch(CompactOnLaunchCallback compactOnLaunch) {
            if (compactOnLaunch == null) {
                throw new IllegalArgumentException("A non-null compactOnLaunch must be provided");
            }
            this.compactOnLaunch = compactOnLaunch;
            return this;
        }

        public Builder urlPrefix(String urlPrefix) {
            if (Util.isEmptyString(urlPrefix)) {
                throw new IllegalArgumentException("Non-empty 'urlPrefix' required");
            }
            this.syncUrlPrefix = urlPrefix;
            return this;
        }

        private String MD5(String in) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] buf = digest.digest(in.getBytes("UTF-8"));
                StringBuilder builder = new StringBuilder();
                for (byte b : buf) {
                    builder.append(String.format(Locale.US, "%02X", b));
                }
                return builder.toString();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RealmException(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new RealmException(e.getMessage());
            }
        }

        public Builder clientResyncMode(ClientResyncMode mode) {
            if (mode == null) {
                throw new IllegalArgumentException("Non-null 'mode' required.");
            }
            this.clientResyncMode = mode;
            return this;
        }

        public SyncConfiguration build() {
            if (this.serverUrl == null || this.user == null) {
                throw new IllegalStateException("serverUrl() and user() are both required.");
            }
            if (this.readOnly) {
                if (this.initialDataTransaction != null) {
                    throw new IllegalStateException("This Realm is marked as read-only. Read-only Realms cannot use initialData(Realm.Transaction).");
                }
                if (!this.waitForServerChanges) {
                    throw new IllegalStateException("A read-only Realms must be provided by some source. 'waitForInitialRemoteData()' wasn't enabled which is currently the only supported source.");
                }
            }
            if (this.serverUrl.toString().contains("/~/") && this.user.getIdentity() == null) {
                throw new IllegalStateException("The serverUrl contains a /~/, but the user does not have an identity. Most likely it hasn't been authenticated yet or has been created directly from an access token. Use a path without /~/.");
            }
            if (this.clientResyncMode == null) {
                ClientResyncMode clientResyncMode = this.clientResyncMode = this.isPartial ? ClientResyncMode.MANUAL : ClientResyncMode.RECOVER_LOCAL_REALM;
            }
            if (this.isPartial && this.clientResyncMode != ClientResyncMode.MANUAL) {
                throw new IllegalStateException("Query-based sync only supports manual Client Resync. It was: " + (Object)((Object)this.clientResyncMode));
            }
            if (this.rxFactory == null && RealmConfiguration.isRxJavaAvailable()) {
                this.rxFactory = new RealmObservableFactory();
            }
            URI resolvedServerUrl = SyncConfiguration.resolveServerUrl(this.serverUrl, this.user.getIdentity());
            File rootDir = this.overrideDefaultFolder ? this.directory : this.defaultFolder;
            String realmPathFromRootDir = this.user.getIdentity() + "/" + SyncConfiguration.getServerPath(resolvedServerUrl);
            File realmFileDirectory = new File(rootDir, realmPathFromRootDir);
            String realmFileName = this.overrideDefaultLocalFileName ? this.fileName : this.defaultLocalFileName;
            String fullPathName = realmFileDirectory.getAbsolutePath() + File.pathSeparator + realmFileName;
            if (fullPathName.length() > 256) {
                realmFileName = this.MD5(realmFileName);
                fullPathName = realmFileDirectory.getAbsolutePath() + File.pathSeparator + realmFileName;
                if (fullPathName.length() > 256 && (fullPathName = (realmFileDirectory = new File(rootDir, this.user.getIdentity())).getAbsolutePath() + File.pathSeparator + realmFileName).length() > 256) {
                    throw new IllegalStateException(String.format(Locale.US, "Full path name must not exceed %d characters: %s", 256, fullPathName));
                }
            }
            if (realmFileName.length() > 255) {
                throw new IllegalStateException(String.format(Locale.US, "File name exceed %d characters: %d", 255, realmFileName.length()));
            }
            for (char c : INVALID_CHARS) {
                realmFileName = realmFileName.replace(c, '_');
            }
            if (!realmFileDirectory.exists() && !realmFileDirectory.mkdirs()) {
                throw new IllegalStateException("Could not create directory for saving the Realm: " + realmFileDirectory);
            }
            if (!Util.isEmptyString(this.serverCertificateAssetName)) {
                if (this.syncClientValidateSsl) {
                    String fileName = this.serverCertificateAssetName.substring(this.serverCertificateAssetName.lastIndexOf(File.separatorChar) + 1);
                    this.serverCertificateFilePath = new File(realmFileDirectory, fileName).getAbsolutePath();
                } else {
                    RealmLog.warn("SSL Verification is disabled, the provided server certificate will not be used.", new Object[0]);
                }
            }
            if (this.isPartial) {
                this.addModule(new ObjectPermissionsModule());
            }
            return new SyncConfiguration(realmFileDirectory, realmFileName, RealmConfiguration.getCanonicalPath(new File(realmFileDirectory, realmFileName)), null, this.key, this.schemaVersion, null, false, this.durability, RealmConfiguration.createSchemaMediator(this.modules, this.debugSchema), this.rxFactory, this.initialDataTransaction, this.readOnly, this.user, resolvedServerUrl, this.errorHandler, this.deleteRealmOnLogout, this.syncClientValidateSsl, this.serverCertificateAssetName, this.serverCertificateFilePath, this.waitForServerChanges, this.initialDataTimeoutMillis, this.sessionStopPolicy, this.isPartial, this.compactOnLaunch, this.syncUrlPrefix, this.clientResyncMode);
        }

        private void checkModule(Object module) {
            if (!module.getClass().isAnnotationPresent(RealmModule.class)) {
                throw new IllegalArgumentException(module.getClass().getCanonicalName() + " is not a RealmModule. Add @RealmModule to the class definition.");
            }
        }
    }
}

