/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.internal.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class SyncCredentials {
    private final String userIdentifier;
    private final String identityProvider;
    private final Map<String, Object> userInfo;

    public static SyncCredentials facebook(String facebookToken) {
        SyncCredentials.assertStringNotEmpty(facebookToken, "facebookToken");
        return new SyncCredentials(facebookToken, "facebook", null);
    }

    public static SyncCredentials google(String googleToken) {
        SyncCredentials.assertStringNotEmpty(googleToken, "googleToken");
        return new SyncCredentials(googleToken, "google", null);
    }

    public static SyncCredentials jwt(String jwtToken) {
        SyncCredentials.assertStringNotEmpty(jwtToken, "jwtToken");
        return new SyncCredentials(jwtToken, "jwt", null);
    }

    public static SyncCredentials anonymous() {
        return new SyncCredentials("", "anonymous", null);
    }

    @Deprecated
    public static SyncCredentials nickname(String nickname, boolean isAdmin) {
        SyncCredentials.assertStringNotEmpty(nickname, "nickname");
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("is_admin", isAdmin);
        return new SyncCredentials(nickname, "nickname", userInfo);
    }

    public static SyncCredentials usernamePassword(String username, String password, boolean createUser) {
        SyncCredentials.assertStringNotEmpty(username, "username");
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("register", createUser);
        userInfo.put("password", password);
        return new SyncCredentials(username, "password", userInfo);
    }

    public static SyncCredentials usernamePassword(String username, String password) {
        return SyncCredentials.usernamePassword(username, password, false);
    }

    public static SyncCredentials custom(String userIdentifier, String identityProvider, @Nullable Map<String, Object> userInfo) {
        SyncCredentials.assertStringNotEmpty(userIdentifier, "userIdentifier");
        SyncCredentials.assertStringNotEmpty(identityProvider, "identityProvider");
        if (userInfo == null) {
            userInfo = new HashMap<String, Object>();
        }
        return new SyncCredentials(userIdentifier, identityProvider, userInfo);
    }

    public static SyncCredentials accessToken(String accessToken, String identifier) {
        return SyncCredentials.accessToken(accessToken, identifier, false);
    }

    public static SyncCredentials accessToken(String accessToken, String identifier, boolean isAdmin) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("_token", accessToken);
        userInfo.put("_isAdmin", isAdmin);
        return new SyncCredentials(identifier, "_access_token", userInfo);
    }

    private static void assertStringNotEmpty(String string, String message) {
        if (Util.isEmptyString(string)) {
            throw new IllegalArgumentException("Non-null '" + message + "' required.");
        }
    }

    private SyncCredentials(String token, String identityProvider, @Nullable Map<String, Object> userInfo) {
        this.identityProvider = identityProvider;
        this.userIdentifier = token;
        this.userInfo = userInfo == null ? new HashMap() : userInfo;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public Map<String, Object> getUserInfo() {
        return Collections.unmodifiableMap(this.userInfo);
    }

    public static final class IdentityProvider {
        public static final String ACCESS_TOKEN = "_access_token";
        public static final String DEBUG = "debug";
        public static final String FACEBOOK = "facebook";
        public static final String GOOGLE = "google";
        public static final String JWT = "jwt";
        public static final String ANONYMOUS = "anonymous";
        @Deprecated
        public static final String NICKNAME = "nickname";
        public static final String USERNAME_PASSWORD = "password";
    }
}

