/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.AuthenticationListener;
import io.realm.ConnectionState;
import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.SyncConfiguration;
import io.realm.SyncSession;
import io.realm.SyncUser;
import io.realm.UserStore;
import io.realm.internal.Keep;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.Util;
import io.realm.internal.network.NetworkStateReceiver;
import io.realm.internal.network.OkHttpRealmObjectServer;
import io.realm.internal.network.RealmObjectServer;
import io.realm.log.RealmLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.internal.tls.OkHostnameVerifier;

@Keep
@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class SyncManager {
    public static String APP_ID = null;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static ThreadPoolExecutor NETWORK_POOL_EXECUTOR = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));
    private static final SyncSession.ErrorHandler SESSION_NO_OP_ERROR_HANDLER = new SyncSession.ErrorHandler(){

        @Override
        public void onError(SyncSession session, ObjectServerError error) {
            if (error.getErrorCode() == ErrorCode.CLIENT_RESET) {
                RealmLog.error("Client Reset required for: " + session.getConfiguration().getServerUrl(), new Object[0]);
                return;
            }
            String errorMsg = String.format(Locale.US, "Session Error[%s]: %s", session.getConfiguration().getServerUrl(), error.toString());
            switch (error.getErrorCode().getCategory()) {
                case FATAL: {
                    RealmLog.error(errorMsg, new Object[0]);
                    break;
                }
                case RECOVERABLE: {
                    RealmLog.info(errorMsg, new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported error category: " + (Object)((Object)error.getErrorCode().getCategory()));
                }
            }
        }
    };
    private static Map<String, SyncSession> sessions = new ConcurrentHashMap<String, SyncSession>();
    private static CopyOnWriteArrayList<AuthenticationListener> authListeners = new CopyOnWriteArrayList();
    private static volatile RealmObjectServer authServer = new OkHttpRealmObjectServer();
    private static volatile UserStore userStore;
    private static String globalAuthorizationHeaderName;
    private static Map<String, String> hostRestrictedAuthorizationHeaderName;
    private static Map<String, String> globalCustomHeaders;
    private static Map<String, Map<String, String>> hostRestrictedCustomHeaders;
    private static NetworkStateReceiver.ConnectionListener networkListener;
    static volatile SyncSession.ErrorHandler defaultSessionErrorHandler;
    private static HashMap<String, List<String>> ROS_CERTIFICATES_CHAIN;
    private static X509TrustManager TRUST_MANAGER;
    private static CertificateFactory CERTIFICATE_FACTORY;

    static void init(String appId, UserStore userStore) {
        APP_ID = appId;
        SyncManager.userStore = userStore;
    }

    public static void setUserStore(UserStore userStore) {
        if (userStore == null) {
            throw new IllegalArgumentException("Non-null 'userStore' required.");
        }
        SyncManager.userStore = userStore;
    }

    public static void addAuthenticationListener(AuthenticationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Non-null 'listener' required.");
        }
        authListeners.add(listener);
    }

    public static void removeAuthenticationListener(AuthenticationListener listener) {
        if (listener == null) {
            return;
        }
        authListeners.remove(listener);
    }

    public static void setDefaultSessionErrorHandler(@Nullable SyncSession.ErrorHandler errorHandler) {
        defaultSessionErrorHandler = errorHandler == null ? SESSION_NO_OP_ERROR_HANDLER : errorHandler;
    }

    public static synchronized SyncSession getSession(SyncConfiguration syncConfiguration) throws IllegalStateException {
        if (syncConfiguration == null) {
            throw new IllegalArgumentException("A non-empty 'syncConfiguration' is required.");
        }
        SyncSession session = sessions.get(syncConfiguration.getPath());
        if (session == null) {
            throw new IllegalStateException("No SyncSession found using the path : " + syncConfiguration.getPath() + "\nplease ensure to call this method after you've open the Realm");
        }
        return session;
    }

    public static synchronized SyncSession getOrCreateSession(SyncConfiguration syncConfiguration, @Nullable URI resolvedRealmURL) {
        if (syncConfiguration == null) {
            throw new IllegalArgumentException("A non-empty 'syncConfiguration' is required.");
        }
        SyncSession session = sessions.get(syncConfiguration.getPath());
        if (session == null) {
            RealmLog.debug("Creating session for: %s", syncConfiguration.getPath());
            session = new SyncSession(syncConfiguration);
            sessions.put(syncConfiguration.getPath(), session);
            if (sessions.size() == 1) {
                RealmLog.debug("First session created. Adding network listener.", new Object[0]);
                NetworkStateReceiver.addListener(networkListener);
            }
            if (resolvedRealmURL != null) {
                session.setResolvedRealmURI(resolvedRealmURL);
                session.getAccessToken(authServer, "");
            }
            OsRealmConfig config = new OsRealmConfig.Builder(syncConfiguration).build();
            SyncManager.nativeCreateSession(config.getNativePtr());
        }
        return session;
    }

    public static synchronized void setAuthorizationHeaderName(String headerName) {
        SyncManager.checkNotEmpty(headerName, "headerName");
        authServer.setAuthorizationHeaderName(headerName, null);
        globalAuthorizationHeaderName = headerName;
    }

    public static synchronized void setAuthorizationHeaderName(String headerName, String host) {
        SyncManager.checkNotEmpty(headerName, "headerName");
        SyncManager.checkNotEmpty(host, "host");
        host = host.toLowerCase(Locale.US);
        authServer.setAuthorizationHeaderName(headerName, host);
        hostRestrictedAuthorizationHeaderName.put(host, headerName);
    }

    public static synchronized void addCustomRequestHeader(String headerName, String headerValue) {
        SyncManager.checkNotEmpty(headerName, "headerName");
        SyncManager.checkNotNull(headerValue, "headerValue");
        authServer.addHeader(headerName, headerValue, null);
        globalCustomHeaders.put(headerName, headerValue);
    }

    public static synchronized void addCustomRequestHeader(String headerName, String headerValue, String host) {
        SyncManager.checkNotEmpty(headerName, "headerName");
        SyncManager.checkNotNull(headerValue, "headerValue");
        SyncManager.checkNotEmpty(host, "host");
        host = host.toLowerCase(Locale.US);
        authServer.addHeader(headerName, headerValue, host);
        Map<String, String> headers = hostRestrictedCustomHeaders.get(host);
        if (headers == null) {
            headers = new LinkedHashMap<String, String>();
            hostRestrictedCustomHeaders.put(host, headers);
        }
        headers.put(headerName, headerValue);
    }

    public static synchronized void addCustomRequestHeaders(@Nullable Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                SyncManager.addCustomRequestHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static synchronized void addCustomRequestHeaders(@Nullable Map<String, String> headers, String host) {
        if (Util.isEmptyString(host)) {
            throw new IllegalArgumentException("Non-empty 'host' required");
        }
        host = host.toLowerCase(Locale.US);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                SyncManager.addCustomRequestHeader(entry.getKey(), entry.getValue(), host);
            }
        }
    }

    public static synchronized String getAuthorizationHeaderName(URI objectServerUrl) {
        String host = objectServerUrl.getHost().toLowerCase(Locale.US);
        String hostRestrictedHeader = hostRestrictedAuthorizationHeaderName.get(host);
        return hostRestrictedHeader != null ? hostRestrictedHeader : globalAuthorizationHeaderName;
    }

    public static synchronized Map<String, String> getCustomRequestHeaders(URI serverSyncUrl) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(globalCustomHeaders);
        String host = serverSyncUrl.getHost().toLowerCase(Locale.US);
        Map<String, String> hostHeaders = hostRestrictedCustomHeaders.get(host);
        if (hostHeaders != null) {
            for (Map.Entry<String, String> entry : hostHeaders.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        return headers;
    }

    private static synchronized void removeSession(SyncConfiguration syncConfiguration) {
        if (syncConfiguration == null) {
            throw new IllegalArgumentException("A non-empty 'syncConfiguration' is required.");
        }
        RealmLog.debug("Removing session for: %s", syncConfiguration.getPath());
        SyncSession syncSession = sessions.remove(syncConfiguration.getPath());
        if (syncSession != null) {
            syncSession.close();
        }
        if (sessions.isEmpty()) {
            RealmLog.debug("Last session dropped. Remove network listener.", new Object[0]);
            NetworkStateReceiver.removeListener(networkListener);
        }
    }

    static List<SyncSession> getAllSessions(SyncUser syncUser) {
        if (syncUser == null) {
            throw new IllegalArgumentException("A non-empty 'syncUser' is required.");
        }
        ArrayList<SyncSession> allSessions = new ArrayList<SyncSession>();
        for (SyncSession syncSession : sessions.values()) {
            if (syncSession.getState() == SyncSession.State.ERROR || !syncSession.getUser().equals(syncUser)) continue;
            allSessions.add(syncSession);
        }
        return allSessions;
    }

    static RealmObjectServer getAuthServer() {
        return authServer;
    }

    static void setAuthServerImpl(RealmObjectServer authServerImpl) {
        authServer = authServerImpl;
    }

    public static UserStore getUserStore() {
        return userStore;
    }

    static void notifyUserLoggedIn(SyncUser user) {
        for (AuthenticationListener authListener : authListeners) {
            authListener.loggedIn(user);
        }
    }

    static void notifyUserLoggedOut(SyncUser user) {
        for (AuthenticationListener authListener : authListeners) {
            authListener.loggedOut(user);
        }
    }

    private static synchronized void notifyErrorHandler(String nativeErrorCategory, int nativeErrorCode, String errorMessage, @Nullable String path) {
        if (Util.isEmptyString(path)) {
            for (SyncSession syncSession : sessions.values()) {
                try {
                    syncSession.notifySessionError(nativeErrorCategory, nativeErrorCode, errorMessage);
                }
                catch (Exception exception) {
                    RealmLog.error(exception);
                }
            }
        } else {
            SyncSession syncSession = sessions.get(path);
            if (syncSession != null) {
                try {
                    syncSession.notifySessionError(nativeErrorCategory, nativeErrorCode, errorMessage);
                }
                catch (Exception exception) {
                    RealmLog.error(exception);
                }
            } else {
                RealmLog.warn("Cannot find the SyncSession corresponding to the path: " + path, new Object[0]);
            }
        }
    }

    private static synchronized void notifyNetworkIsBack() {
        try {
            SyncManager.nativeReconnect();
        }
        catch (Exception exception) {
            RealmLog.error(exception);
        }
    }

    private static synchronized void notifyProgressListener(String localRealmPath, long listenerId, long transferedBytes, long transferableBytes) {
        SyncSession session = sessions.get(localRealmPath);
        if (session != null) {
            try {
                session.notifyProgressListener(listenerId, transferedBytes, transferableBytes);
            }
            catch (Exception exception) {
                RealmLog.error(exception);
            }
        }
    }

    private static synchronized void notifyConnectionListeners(String localRealmPath, long oldState, long newState) {
        SyncSession session = sessions.get(localRealmPath);
        if (session != null) {
            try {
                session.notifyConnectionListeners(ConnectionState.fromNativeValue(oldState), ConnectionState.fromNativeValue(newState));
            }
            catch (Exception exception) {
                RealmLog.error(exception);
            }
        }
    }

    private static synchronized String bindSessionWithConfig(String sessionPath, String refreshToken) {
        SyncSession syncSession = sessions.get(sessionPath);
        if (syncSession == null) {
            RealmLog.error("Matching Java SyncSession could not be found for: " + sessionPath, new Object[0]);
        } else {
            try {
                return syncSession.getAccessToken(authServer, refreshToken);
            }
            catch (Exception exception) {
                RealmLog.error(exception);
            }
        }
        return null;
    }

    public static void refreshConnections() {
        SyncManager.notifyNetworkIsBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized boolean sslVerifyCallback(String serverAddress, String pemData, int depth) {
        try {
            if (ROS_CERTIFICATES_CHAIN == null) {
                ROS_CERTIFICATES_CHAIN = new HashMap();
                TRUST_MANAGER = SyncManager.systemDefaultTrustManager();
                CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
            }
            if (!ROS_CERTIFICATES_CHAIN.containsKey(serverAddress)) {
                ROS_CERTIFICATES_CHAIN.put(serverAddress, new ArrayList());
            }
            ROS_CERTIFICATES_CHAIN.get(serverAddress).add(pemData);
            if (depth != 0) return true;
            List<String> pemChain = ROS_CERTIFICATES_CHAIN.get(serverAddress);
            int n = pemChain.size();
            X509Certificate[] chain = new X509Certificate[n];
            for (String pem : pemChain) {
                chain[--n] = SyncManager.buildCertificateFromPEM(pem);
            }
            try {
                TRUST_MANAGER.checkClientTrusted(chain, "RSA");
                boolean isValid = OkHostnameVerifier.INSTANCE.verify(serverAddress, chain[0]);
                if (isValid) {
                    boolean bl = true;
                    return bl;
                }
                RealmLog.error("Can not verify the hostname for the host: " + serverAddress, new Object[0]);
                boolean bl = false;
                return bl;
            }
            catch (CertificateException e) {
                RealmLog.error(e, "Can not validate SSL chain certificate for the host: " + serverAddress, new Object[0]);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                ROS_CERTIFICATES_CHAIN.remove(serverAddress);
            }
        }
        catch (Exception e2) {
            RealmLog.error(e2, "Error during certificate validation for host: " + serverAddress, new Object[0]);
            return false;
        }
    }

    private static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("No System TLS", e);
        }
    }

    private static X509Certificate buildCertificateFromPEM(String pem) throws IOException, CertificateException {
        try (InputStream stream = null;){
            stream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
            X509Certificate x509Certificate = (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(stream);
            return x509Certificate;
        }
    }

    private static void checkNotEmpty(String headerName, String varName) {
        if (Util.isEmptyString(headerName)) {
            throw new IllegalArgumentException("Non-empty '" + varName + "' required.");
        }
    }

    private static void checkNotNull(@Nullable String val, String varName) {
        if (val == null) {
            throw new IllegalArgumentException("Non-null'" + varName + "' required.");
        }
    }

    static synchronized void reset() {
        SyncManager.nativeReset();
        sessions.clear();
        hostRestrictedAuthorizationHeaderName.clear();
        globalAuthorizationHeaderName = "Authorization";
        hostRestrictedCustomHeaders.clear();
        globalCustomHeaders.clear();
        authServer.clearCustomHeaderSettings();
    }

    static void simulateClientReset(SyncSession session) {
        SyncManager.nativeSimulateSyncError(session.getConfiguration().getPath(), ErrorCode.DIVERGING_HISTORIES.intValue(), "Simulate Client Reset", true);
    }

    protected static native void nativeInitializeSyncManager(String var0, String var1, String var2);

    private static native void nativeReset();

    private static native void nativeSimulateSyncError(String var0, int var1, String var2, boolean var3);

    private static native void nativeReconnect();

    private static native void nativeCreateSession(long var0);

    static {
        globalAuthorizationHeaderName = "Authorization";
        hostRestrictedAuthorizationHeaderName = new HashMap<String, String>();
        globalCustomHeaders = new HashMap<String, String>();
        hostRestrictedCustomHeaders = new HashMap<String, Map<String, String>>();
        networkListener = new NetworkStateReceiver.ConnectionListener(){

            @Override
            public void onChange(boolean connectionAvailable) {
                if (connectionAvailable) {
                    RealmLog.debug("NetworkListener: Connection available", new Object[0]);
                    SyncManager.notifyNetworkIsBack();
                } else {
                    RealmLog.debug("NetworkListener: Connection lost", new Object[0]);
                }
            }
        };
        defaultSessionErrorHandler = SESSION_NO_OP_ERROR_HANDLER;
    }

    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static class Debug {
        public static boolean skipOnlineChecking = false;
        public static boolean separatedDirForSyncManager = false;
    }
}

