/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.ClientResetRequiredError;
import io.realm.ConnectionListener;
import io.realm.ConnectionState;
import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.Progress;
import io.realm.ProgressListener;
import io.realm.ProgressMode;
import io.realm.RealmAsyncTask;
import io.realm.RealmConfiguration;
import io.realm.SyncConfiguration;
import io.realm.SyncManager;
import io.realm.SyncUser;
import io.realm.internal.Keep;
import io.realm.internal.SyncObjectServerFacade;
import io.realm.internal.Util;
import io.realm.internal.android.AndroidCapabilities;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.internal.network.AuthenticateResponse;
import io.realm.internal.network.ExponentialBackoffTask;
import io.realm.internal.network.NetworkStateReceiver;
import io.realm.internal.network.RealmObjectServer;
import io.realm.internal.objectserver.SyncWorker;
import io.realm.internal.objectserver.Token;
import io.realm.internal.util.Pair;
import io.realm.log.RealmLog;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SyncSession {
    private static final ScheduledThreadPoolExecutor REFRESH_TOKENS_EXECUTOR = new ScheduledThreadPoolExecutor(1);
    private static final long REFRESH_MARGIN_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private static final int DIRECTION_DOWNLOAD = 1;
    private static final int DIRECTION_UPLOAD = 2;
    private final SyncConfiguration configuration;
    private final ErrorHandler errorHandler;
    private RealmAsyncTask networkRequest;
    private RealmAsyncTask refreshTokenTask;
    private RealmAsyncTask refreshTokenNetworkRequest;
    private AtomicBoolean onGoingAccessTokenQuery = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private final AtomicReference<WaitForSessionWrapper> waitingForServerChanges = new AtomicReference<Object>(null);
    private final AtomicInteger waitCounter = new AtomicInteger(0);
    private final Object waitForChangesMutex = new Object();
    private final Map<Long, Pair<ProgressListener, Progress>> listenerIdToProgressListenerMap = new HashMap<Long, Pair<ProgressListener, Progress>>();
    private final Map<ProgressListener, Long> progressListenerToOsTokenMap = new IdentityHashMap<ProgressListener, Long>();
    private final AtomicLong progressListenerId = new AtomicLong(-1L);
    private static final byte STATE_VALUE_WAITING_FOR_ACCESS_TOKEN = 0;
    private static final byte STATE_VALUE_ACTIVE = 1;
    private static final byte STATE_VALUE_DYING = 2;
    private static final byte STATE_VALUE_INACTIVE = 3;
    private static final byte STATE_VALUE_ERROR = 4;
    private final CopyOnWriteArrayList<ConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    private long nativeConnectionListenerToken;
    static final byte CONNECTION_VALUE_DISCONNECTED = 0;
    static final byte CONNECTION_VALUE_CONNECTING = 1;
    static final byte CONNECTION_VALUE_CONNECTED = 2;
    private URI resolvedRealmURI;

    SyncSession(SyncConfiguration configuration) {
        this.configuration = configuration;
        this.errorHandler = configuration.getErrorHandler();
    }

    public SyncConfiguration getConfiguration() {
        return this.configuration;
    }

    public SyncUser getUser() {
        return this.configuration.getUser();
    }

    public URI getServerUrl() {
        return this.configuration.getServerUrl();
    }

    void notifySessionError(String nativeErrorCategory, int nativeErrorCode, String errorMessage) {
        if (this.errorHandler == null) {
            return;
        }
        ErrorCode errCode = ErrorCode.fromNativeError(nativeErrorCategory, nativeErrorCode);
        if (errCode == ErrorCode.CLIENT_RESET) {
            RealmConfiguration backupRealmConfiguration = SyncConfiguration.forRecovery(errorMessage, this.configuration.getEncryptionKey(), this.configuration.getSchemaMediator());
            this.errorHandler.onError(this, new ClientResetRequiredError(errCode, "A Client Reset is required. Read more here: https://realm.io/docs/realm-object-server/#client-recovery-from-a-backup.", this.configuration, backupRealmConfiguration));
        } else {
            ObjectServerError wrappedError = errCode == ErrorCode.UNKNOWN ? new ObjectServerError(nativeErrorCategory, nativeErrorCode, errorMessage) : new ObjectServerError(errCode, errorMessage);
            this.errorHandler.onError(this, wrappedError);
        }
    }

    public State getState() {
        byte state = SyncSession.nativeGetState(this.configuration.getPath());
        if (state == -1) {
            throw new IllegalStateException("Could not find session, Realm was probably closed");
        }
        return State.fromNativeValue(state);
    }

    public ConnectionState getConnectionState() {
        byte state = SyncSession.nativeGetConnectionState(this.configuration.getPath());
        if (state == -1) {
            throw new IllegalStateException("Could not find session, Realm was probably closed");
        }
        return ConnectionState.fromNativeValue(state);
    }

    public boolean isConnected() {
        ConnectionState connectionState = ConnectionState.fromNativeValue(SyncSession.nativeGetConnectionState(this.configuration.getPath()));
        State sessionState = this.getState();
        return (sessionState == State.ACTIVE || sessionState == State.DYING) && connectionState == ConnectionState.CONNECTED;
    }

    synchronized void notifyProgressListener(long listenerId, long transferredBytes, long transferableBytes) {
        Pair<ProgressListener, Progress> listener = this.listenerIdToProgressListenerMap.get(listenerId);
        if (listener != null) {
            Progress newProgressNotification = new Progress(transferredBytes, transferableBytes);
            if (!newProgressNotification.equals(listener.second)) {
                listener.second = newProgressNotification;
                ((ProgressListener)listener.first).onChange(newProgressNotification);
            }
        } else {
            RealmLog.debug("Trying unknown listener failed: " + listenerId, new Object[0]);
        }
    }

    void notifyConnectionListeners(ConnectionState oldState, ConnectionState newState) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.onChange(oldState, newState);
        }
    }

    public synchronized void addDownloadProgressListener(ProgressMode mode, ProgressListener listener) {
        this.addProgressListener(mode, 1, listener);
    }

    public synchronized void addUploadProgressListener(ProgressMode mode, ProgressListener listener) {
        this.addProgressListener(mode, 2, listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        Long token = this.progressListenerToOsTokenMap.remove(listener);
        if (token != null) {
            Iterator<Map.Entry<Long, Pair<ProgressListener, Progress>>> it = this.listenerIdToProgressListenerMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Pair<ProgressListener, Progress>> entry = it.next();
                if (!((ProgressListener)entry.getValue().first).equals(listener)) continue;
                it.remove();
                break;
            }
            SyncSession.nativeRemoveProgressListener(this.configuration.getPath(), token);
        }
    }

    private void addProgressListener(ProgressMode mode, int direction, ProgressListener listener) {
        this.checkProgressListenerArguments(mode, listener);
        boolean isStreaming = mode == ProgressMode.INDEFINITELY;
        long listenerId = this.progressListenerId.incrementAndGet();
        this.listenerIdToProgressListenerMap.put(listenerId, new Pair<ProgressListener, Object>(listener, null));
        long listenerToken = SyncSession.nativeAddProgressListener(this.configuration.getPath(), listenerId, direction, isStreaming);
        if (listenerToken == 0L) {
            this.listenerIdToProgressListenerMap.remove(listenerId);
        } else {
            this.progressListenerToOsTokenMap.put(listener, listenerToken);
        }
    }

    private void checkProgressListenerArguments(ProgressMode mode, ProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Non-null 'listener' required.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Non-null 'mode' required.");
        }
    }

    public synchronized void addConnectionChangeListener(ConnectionListener listener) {
        this.checkNonNullListener(listener);
        if (this.connectionListeners.isEmpty()) {
            this.nativeConnectionListenerToken = SyncSession.nativeAddConnectionListener(this.configuration.getPath());
        }
        this.connectionListeners.add(listener);
    }

    public synchronized void removeConnectionChangeListener(ConnectionListener listener) {
        this.checkNonNullListener(listener);
        this.connectionListeners.remove(listener);
        if (this.connectionListeners.isEmpty()) {
            SyncSession.nativeRemoveConnectionListener(this.nativeConnectionListenerToken, this.configuration.getPath());
        }
    }

    void close() {
        this.isClosed = true;
        if (this.networkRequest != null) {
            this.networkRequest.cancel();
        }
        this.clearScheduledAccessTokenRefresh();
    }

    private void notifyAllChangesSent(int callbackId, Long errorcode, String errorMessage) {
        WaitForSessionWrapper wrapper = this.waitingForServerChanges.get();
        if (wrapper != null && this.waitCounter.get() == callbackId) {
            wrapper.handleResult(errorcode, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAllServerChanges() throws InterruptedException {
        this.checkIfNotOnMainThread("downloadAllServerChanges() cannot be called from the main thread.");
        Object object = this.waitForChangesMutex;
        synchronized (object) {
            this.waitForChanges(1, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadAllServerChanges(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkIfNotOnMainThread("downloadAllServerChanges() cannot be called from the main thread.");
        this.checkTimeout(timeout, unit);
        Object object = this.waitForChangesMutex;
        synchronized (object) {
            return this.waitForChanges(1, timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadAllLocalChanges() throws InterruptedException {
        this.checkIfNotOnMainThread("uploadAllLocalChanges() cannot be called from the main thread.");
        Object object = this.waitForChangesMutex;
        synchronized (object) {
            this.waitForChanges(2, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadAllLocalChanges(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkIfNotOnMainThread("uploadAllLocalChanges() cannot be called from the main thread.");
        this.checkTimeout(timeout, unit);
        Object object = this.waitForChangesMutex;
        synchronized (object) {
            return this.waitForChanges(2, timeout, unit);
        }
    }

    public synchronized void start() {
        SyncSession.nativeStart(this.configuration.getPath());
    }

    public synchronized void stop() {
        SyncSession.nativeStop(this.configuration.getPath());
    }

    void setResolvedRealmURI(URI resolvedRealmURI) {
        this.resolvedRealmURI = resolvedRealmURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForChanges(int direction, long timeout, TimeUnit unit) throws InterruptedException {
        if (direction != 1 && direction != 2) {
            throw new IllegalArgumentException("Unknown direction: " + direction);
        }
        boolean result = false;
        if (!this.isClosed) {
            boolean listenerRegistered;
            String realmPath = this.configuration.getPath();
            WaitForSessionWrapper wrapper = new WaitForSessionWrapper();
            this.waitingForServerChanges.set(wrapper);
            int callbackId = this.waitCounter.incrementAndGet();
            boolean bl = listenerRegistered = direction == 1 ? this.nativeWaitForDownloadCompletion(callbackId, realmPath) : this.nativeWaitForUploadCompletion(callbackId, realmPath);
            if (!listenerRegistered) {
                String errorMsg;
                this.waitingForServerChanges.set(null);
                switch (direction) {
                    case 1: {
                        errorMsg = "It was not possible to download all remote changes.";
                        break;
                    }
                    case 2: {
                        errorMsg = "It was not possible upload all local changes.";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown direction: " + direction);
                    }
                }
                throw new ObjectServerError(ErrorCode.UNKNOWN, errorMsg + " Has the SyncClient been started?");
            }
            try {
                result = wrapper.waitForServerChanges(timeout, unit);
            }
            catch (InterruptedException e) {
                this.waitingForServerChanges.set(null);
                throw e;
            }
            try {
                if (!this.isClosed && !wrapper.isSuccess()) {
                    wrapper.throwExceptionIfNeeded();
                }
            }
            finally {
                this.waitingForServerChanges.set(null);
            }
        }
        return result;
    }

    private void checkIfNotOnMainThread(String errorMessage) {
        if (new AndroidCapabilities().isMainThread()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private void checkTimeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("'timeout' must be > 0. It was: " + timeout);
        }
        if (unit == null) {
            throw new IllegalArgumentException("Non-null 'unit' required");
        }
    }

    private void checkNonNullListener(@Nullable Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Non-null 'listener' required.");
        }
    }

    String getAccessToken(RealmObjectServer authServer, String refreshToken) {
        if (this.getUser().isRealmAuthenticated(this.configuration)) {
            Token accessToken = this.getUser().getAccessToken(this.configuration);
            if (!this.onGoingAccessTokenQuery.getAndSet(true)) {
                this.scheduleRefreshAccessToken(authServer, accessToken.expiresMs());
            }
            return accessToken.value();
        }
        if (!Util.isEmptyString(refreshToken)) {
            try {
                JSONObject refreshTokenJSON = new JSONObject(refreshToken);
                Token newRefreshToken = Token.from(refreshTokenJSON.getJSONObject("userToken"));
                if (newRefreshToken.hashCode() != this.getUser().getRefreshToken().hashCode()) {
                    RealmLog.debug("Session[%s]: Access token updated", this.configuration.getPath());
                    this.getUser().setRefreshToken(newRefreshToken);
                }
            }
            catch (JSONException e) {
                RealmLog.error(e, "Session[%s]: Can not parse the refresh_token into a valid JSONObject: ", this.configuration.getPath());
            }
        }
        if (!this.onGoingAccessTokenQuery.get() && NetworkStateReceiver.isOnline(SyncObjectServerFacade.getApplicationContext())) {
            this.authenticateRealm(authServer);
        }
        return null;
    }

    private void authenticateRealm(final RealmObjectServer authServer) {
        if (this.networkRequest != null) {
            this.networkRequest.cancel();
        }
        this.clearScheduledAccessTokenRefresh();
        this.onGoingAccessTokenQuery.set(true);
        Future<?> task = SyncManager.NETWORK_POOL_EXECUTOR.submit(new ExponentialBackoffTask<AuthenticateResponse>(){

            @Override
            protected AuthenticateResponse execute() {
                if (!SyncSession.this.isClosed && !Thread.currentThread().isInterrupted()) {
                    return authServer.loginToRealm(SyncSession.this.getUser().getRefreshToken(), SyncSession.this.resolvedRealmURI, SyncSession.this.getUser().getAuthenticationUrl());
                }
                return null;
            }

            @Override
            protected void onSuccess(AuthenticateResponse response) {
                RealmLog.debug("Session[%s]: Access token acquired", SyncSession.this.configuration.getPath());
                if (!SyncSession.this.isClosed && !Thread.currentThread().isInterrupted()) {
                    URI realmUrl = SyncSession.this.configuration.getServerUrl();
                    SyncSession.this.getUser().addRealm(SyncSession.this.configuration, response.getAccessToken());
                    if (SyncSession.nativeRefreshAccessToken(SyncSession.this.configuration.getPath(), response.getAccessToken().value(), realmUrl.toString())) {
                        SyncSession.this.scheduleRefreshAccessToken(authServer, response.getAccessToken().expiresMs());
                    } else {
                        SyncSession.this.onGoingAccessTokenQuery.set(false);
                    }
                }
            }

            @Override
            protected void onError(AuthenticateResponse response) {
                SyncSession.this.onGoingAccessTokenQuery.set(false);
                RealmLog.debug("Session[%s]: Failed to get access token (%s)", new Object[]{SyncSession.this.configuration.getPath(), response.getError().getErrorCode()});
                if (!(SyncSession.this.isClosed || Thread.currentThread().isInterrupted() || response.getError().getException() instanceof InterruptedIOException)) {
                    SyncSession.this.errorHandler.onError(SyncSession.this, response.getError());
                }
            }
        });
        this.networkRequest = new RealmAsyncTaskImpl(task, SyncManager.NETWORK_POOL_EXECUTOR);
    }

    private void scheduleRefreshAccessToken(final RealmObjectServer authServer, long expireDateInMs) {
        this.onGoingAccessTokenQuery.set(true);
        long refreshAfter = expireDateInMs - System.currentTimeMillis() - REFRESH_MARGIN_DELAY;
        if (refreshAfter < 0L) {
            RealmLog.debug("Expires time already reached for the access token, refresh as soon as possible", new Object[0]);
            refreshAfter = REFRESH_MARGIN_DELAY;
        }
        RealmLog.debug("Scheduling an access_token refresh in " + refreshAfter + " milliseconds", new Object[0]);
        if (this.refreshTokenTask != null) {
            this.refreshTokenTask.cancel();
        }
        ScheduledFuture<?> task = REFRESH_TOKENS_EXECUTOR.schedule(new Runnable(){

            @Override
            public void run() {
                if (!(SyncSession.this.isClosed || Thread.currentThread().isInterrupted() || SyncSession.this.refreshTokenTask.isCancelled())) {
                    SyncSession.this.refreshAccessToken(authServer);
                }
            }
        }, refreshAfter, TimeUnit.MILLISECONDS);
        this.refreshTokenTask = new RealmAsyncTaskImpl(task, REFRESH_TOKENS_EXECUTOR);
    }

    private void refreshAccessToken(final RealmObjectServer authServer) {
        this.clearScheduledAccessTokenRefresh();
        Future<?> task = SyncManager.NETWORK_POOL_EXECUTOR.submit(new ExponentialBackoffTask<AuthenticateResponse>(){

            @Override
            protected AuthenticateResponse execute() {
                if (!SyncSession.this.isClosed && !Thread.currentThread().isInterrupted()) {
                    return authServer.refreshUser(SyncSession.this.getUser().getRefreshToken(), SyncSession.this.resolvedRealmURI, SyncSession.this.getUser().getAuthenticationUrl());
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onSuccess(AuthenticateResponse response) {
                SyncSession syncSession = SyncSession.this;
                synchronized (syncSession) {
                    if (!(SyncSession.this.isClosed || Thread.currentThread().isInterrupted() || SyncSession.this.refreshTokenNetworkRequest.isCancelled())) {
                        RealmLog.debug("Access Token refreshed successfully, Sync URL: " + SyncSession.this.configuration.getServerUrl(), new Object[0]);
                        SyncWorker syncWorker = response.getSyncWorker();
                        if (syncWorker != null) {
                            SyncSession.nativeSetUrlPrefix(SyncSession.this.configuration.getPath(), syncWorker.path());
                        }
                        URI realmUrl = SyncSession.this.configuration.getServerUrl();
                        if (SyncSession.nativeRefreshAccessToken(SyncSession.this.configuration.getPath(), response.getAccessToken().value(), realmUrl.toString())) {
                            SyncSession.this.getUser().addRealm(SyncSession.this.configuration, response.getAccessToken());
                            SyncSession.this.scheduleRefreshAccessToken(authServer, response.getAccessToken().expiresMs());
                        }
                    }
                }
            }

            @Override
            protected void onError(AuthenticateResponse response) {
                if (!SyncSession.this.isClosed && !Thread.currentThread().isInterrupted()) {
                    SyncSession.this.onGoingAccessTokenQuery.set(false);
                    RealmLog.error("Unrecoverable error, while refreshing the access Token (" + response.getError().toString() + ") reschedule will not happen", new Object[0]);
                }
            }
        });
        this.refreshTokenNetworkRequest = new RealmAsyncTaskImpl(task, SyncManager.NETWORK_POOL_EXECUTOR);
    }

    void clearScheduledAccessTokenRefresh() {
        if (this.refreshTokenTask != null) {
            this.refreshTokenTask.cancel();
        }
        if (this.refreshTokenNetworkRequest != null) {
            this.refreshTokenNetworkRequest.cancel();
        }
        this.onGoingAccessTokenQuery.set(false);
    }

    private static native long nativeAddConnectionListener(String var0);

    private static native void nativeRemoveConnectionListener(long var0, String var2);

    private static native long nativeAddProgressListener(String var0, long var1, int var3, boolean var4);

    private static native void nativeRemoveProgressListener(String var0, long var1);

    private static native boolean nativeRefreshAccessToken(String var0, String var1, String var2);

    private native boolean nativeWaitForDownloadCompletion(int var1, String var2);

    private native boolean nativeWaitForUploadCompletion(int var1, String var2);

    private static native byte nativeGetState(String var0);

    private static native byte nativeGetConnectionState(String var0);

    private static native void nativeStart(String var0);

    private static native void nativeStop(String var0);

    private static native void nativeSetUrlPrefix(String var0, String var1);

    private static class WaitForSessionWrapper {
        private final CountDownLatch waiter = new CountDownLatch(1);
        private volatile boolean resultReceived = false;
        private Long errorCode = null;
        private String errorMessage;

        private WaitForSessionWrapper() {
        }

        public boolean waitForServerChanges(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.resultReceived) {
                return this.waiter.await(timeout, unit);
            }
            return this.isSuccess();
        }

        public void handleResult(Long errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            this.resultReceived = true;
            this.waiter.countDown();
        }

        public boolean isSuccess() {
            return this.resultReceived && this.errorCode == null;
        }

        public void throwExceptionIfNeeded() {
            if (this.resultReceived && this.errorCode != null) {
                throw new ObjectServerError(ErrorCode.UNKNOWN, String.format(Locale.US, "Internal error (%d): %s", this.errorCode, this.errorMessage));
            }
        }
    }

    public static interface ErrorHandler {
        public void onError(SyncSession var1, ObjectServerError var2);
    }

    public static enum State {
        INACTIVE(3),
        WAITING_FOR_ACCESS_TOKEN(0),
        ACTIVE(1),
        DYING(2),
        ERROR(4);

        final byte value;

        private State(byte value) {
            this.value = value;
        }

        static State fromNativeValue(long value) {
            State[] stateCodes;
            for (State state : stateCodes = State.values()) {
                if ((long)state.value != value) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown session state code: " + value);
        }
    }
}

