/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.Realm;
import io.realm.RealmAsyncTask;
import io.realm.SyncConfiguration;
import io.realm.SyncCredentials;
import io.realm.SyncManager;
import io.realm.SyncSession;
import io.realm.SyncUserInfo;
import io.realm.UserStore;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Util;
import io.realm.internal.android.AndroidCapabilities;
import io.realm.internal.android.AndroidRealmNotifier;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.internal.network.AcceptPermissionsOfferResponse;
import io.realm.internal.network.ApplyPermissionsResponse;
import io.realm.internal.network.AuthenticateResponse;
import io.realm.internal.network.ChangePasswordResponse;
import io.realm.internal.network.ExponentialBackoffTask;
import io.realm.internal.network.GetPermissionsOffersResponse;
import io.realm.internal.network.InvalidatePermissionsOfferResponse;
import io.realm.internal.network.LogoutResponse;
import io.realm.internal.network.LookupUserIdResponse;
import io.realm.internal.network.MakePermissionsOfferResponse;
import io.realm.internal.network.RealmObjectServer;
import io.realm.internal.network.RetrievePermissionsResponse;
import io.realm.internal.network.UpdateAccountResponse;
import io.realm.internal.objectserver.Token;
import io.realm.log.RealmLog;
import io.realm.permissions.Permission;
import io.realm.permissions.PermissionOffer;
import io.realm.permissions.PermissionRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncUser {
    private final String identity;
    private Token refreshToken;
    private final URL baseUrl;
    private final URL authenticationUrl;
    private final Map<SyncConfiguration, Token> realms = new HashMap<SyncConfiguration, Token>();
    private SyncConfiguration defaultConfiguration;

    SyncUser(Token refreshToken, URL authenticationUrl) {
        this.identity = refreshToken.identity();
        this.authenticationUrl = authenticationUrl;
        try {
            this.baseUrl = new URL(authenticationUrl.getProtocol(), authenticationUrl.getHost(), authenticationUrl.getPort(), "");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.refreshToken = refreshToken;
    }

    public static SyncUser current() {
        SyncUser user = SyncManager.getUserStore().getCurrent();
        if (user != null && user.isValid()) {
            return user;
        }
        return null;
    }

    public static Map<String, SyncUser> all() {
        UserStore userStore = SyncManager.getUserStore();
        Collection<SyncUser> storedUsers = userStore.allUsers();
        HashMap<String, SyncUser> map = new HashMap<String, SyncUser>();
        for (SyncUser user : storedUsers) {
            if (!user.isValid()) continue;
            map.put(user.getIdentity(), user);
        }
        return Collections.unmodifiableMap(map);
    }

    public static SyncUser fromJson(String user) {
        try {
            JSONObject obj = new JSONObject(user);
            URL authUrl = new URL(obj.getString("authUrl"));
            Token userToken = Token.from(obj.getJSONObject("userToken"));
            return new SyncUser(userToken, authUrl);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not parse user json: " + user, e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL in JSON not valid: " + user, e);
        }
    }

    public static SyncUser logIn(SyncCredentials credentials, String authenticationUrl) throws ObjectServerError {
        ObjectServerError error;
        URL authUrl = SyncUser.getUrl(authenticationUrl);
        try {
            AuthenticateResponse result;
            if (credentials.getIdentityProvider().equals("_access_token")) {
                String userIdentifier = credentials.getUserIdentifier();
                String token = (String)credentials.getUserInfo().get("_token");
                boolean isAdmin = (Boolean)credentials.getUserInfo().get("_isAdmin");
                result = AuthenticateResponse.createValidResponseWithUser(userIdentifier, token, isAdmin);
            } else {
                RealmObjectServer server = SyncManager.getAuthServer();
                result = server.loginUser(credentials, authUrl);
            }
            if (result.isValid()) {
                SyncUser user = new SyncUser(result.getRefreshToken(), authUrl);
                RealmLog.info("Succeeded authenticating user.\n%s", user);
                SyncManager.getUserStore().put(user);
                SyncManager.notifyUserLoggedIn(user);
                return user;
            }
            RealmLog.info("Failed authenticating user.\n%s", result.getError());
            error = result.getError();
        }
        catch (Throwable e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, e);
        }
        throw error;
    }

    private static URL getUrl(String authenticationUrl) {
        try {
            URL authUrl = new URL(authenticationUrl);
            if (authUrl.getPath().equals("")) {
                authUrl = new URL(authUrl.toString() + "/auth");
            }
            return authUrl;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL " + authenticationUrl + ".", e);
        }
    }

    public static RealmAsyncTask logInAsync(final SyncCredentials credentials, final String authenticationUrl, Callback<SyncUser> callback) {
        SyncUser.checkLooperThread("Asynchronous login is only possible from looper threads.");
        return new Request<SyncUser>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public SyncUser run() throws ObjectServerError {
                return SyncUser.logIn(credentials, authenticationUrl);
            }
        }.start();
    }

    public SyncConfiguration.Builder createConfiguration(String uri) {
        if (!this.isValid()) {
            throw new IllegalStateException("Configurations can only be created from valid users");
        }
        return new SyncConfiguration.Builder(this, uri).partialRealm();
    }

    public SyncConfiguration getDefaultConfiguration() {
        if (!this.isValid()) {
            throw new IllegalStateException("The default configuration can only be created for users that are logged in.");
        }
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = new SyncConfiguration.Builder(this, SyncUser.createUrl(this)).partialRealm().build();
        }
        return this.defaultConfiguration;
    }

    private static String createUrl(SyncUser user) {
        URL url = user.getAuthenticationUrl();
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        protocol = protocol.equalsIgnoreCase("https") ? "realms" : "realm";
        return protocol + "://" + host + "/default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut() {
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            if (!SyncManager.getUserStore().isActive(this.identity, this.authenticationUrl.toString())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            SyncManager.getUserStore().remove(this.identity, this.authenticationUrl.toString());
            for (SyncConfiguration syncConfiguration : this.realms.keySet()) {
                try {
                    SyncSession session = SyncManager.getSession(syncConfiguration);
                    session.clearScheduledAccessTokenRefresh();
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("No SyncSession found")) continue;
                    throw e;
                }
            }
            this.realms.clear();
            final RealmObjectServer server = SyncManager.getAuthServer();
            final Token refreshTokenToBeRevoked = this.refreshToken;
            ThreadPoolExecutor networkPoolExecutor = SyncManager.NETWORK_POOL_EXECUTOR;
            networkPoolExecutor.submit(new ExponentialBackoffTask<LogoutResponse>(3){

                @Override
                protected LogoutResponse execute() {
                    return server.logout(refreshTokenToBeRevoked, SyncUser.this.getAuthenticationUrl());
                }

                @Override
                protected void onSuccess(LogoutResponse response) {
                    SyncManager.notifyUserLoggedOut(SyncUser.this);
                }

                @Override
                protected void onError(LogoutResponse response) {
                    RealmLog.error("Failed to log user out.\n" + response.getError().toString(), new Object[0]);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void changePassword(String newPassword) throws ObjectServerError {
        if (newPassword == null) {
            throw new IllegalArgumentException("Not-null 'newPassword' required.");
        }
        RealmObjectServer authServer = SyncManager.getAuthServer();
        ChangePasswordResponse response = authServer.changePassword(this.refreshToken, newPassword, this.getAuthenticationUrl());
        if (!response.isValid()) {
            throw response.getError();
        }
    }

    public void changePassword(String userId, String newPassword) throws ObjectServerError {
        if (newPassword == null) {
            throw new IllegalArgumentException("Not-null 'newPassword' required.");
        }
        if (Util.isEmptyString(userId)) {
            throw new IllegalArgumentException("None empty 'userId' required.");
        }
        if (userId.equals(this.getIdentity())) {
            this.changePassword(newPassword);
        } else {
            if (!this.isAdmin()) {
                throw new IllegalStateException("User need to be admin in order to change another user's password.");
            }
            RealmObjectServer authServer = SyncManager.getAuthServer();
            ChangePasswordResponse response = authServer.changePassword(this.refreshToken, userId, newPassword, this.getAuthenticationUrl());
            if (!response.isValid()) {
                throw response.getError();
            }
        }
    }

    public RealmAsyncTask changePasswordAsync(final String newPassword, Callback<SyncUser> callback) {
        SyncUser.checkLooperThread("Asynchronous changing password is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<SyncUser>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public SyncUser run() {
                SyncUser.this.changePassword(newPassword);
                return SyncUser.this;
            }
        }.start();
    }

    public RealmAsyncTask changePasswordAsync(final String userId, final String newPassword, Callback<SyncUser> callback) {
        SyncUser.checkLooperThread("Asynchronous changing password is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<SyncUser>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public SyncUser run() {
                SyncUser.this.changePassword(userId, newPassword);
                return SyncUser.this;
            }
        }.start();
    }

    public static void requestPasswordReset(String email, String authenticationUrl) throws ObjectServerError {
        if (Util.isEmptyString(email)) {
            throw new IllegalArgumentException("Not-null 'email' required.");
        }
        URL authUrl = SyncUser.getUrl(authenticationUrl);
        RealmObjectServer authServer = SyncManager.getAuthServer();
        UpdateAccountResponse response = authServer.requestPasswordReset(email, authUrl);
        if (!response.isValid()) {
            throw response.getError();
        }
    }

    public static RealmAsyncTask requestPasswordResetAsync(final String email, final String authenticationUrl, Callback<Void> callback) {
        SyncUser.checkLooperThread("Asynchronous requesting a password reset is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() {
                SyncUser.requestPasswordReset(email, authenticationUrl);
                return null;
            }
        }.start();
    }

    public static void completePasswordReset(String resetToken, String newPassword, String authenticationUrl) {
        if (Util.isEmptyString(resetToken)) {
            throw new IllegalArgumentException("Not-null 'token' required.");
        }
        if (Util.isEmptyString(newPassword)) {
            throw new IllegalArgumentException("Not-null 'newPassword' required.");
        }
        URL authUrl = SyncUser.getUrl(authenticationUrl);
        RealmObjectServer authServer = SyncManager.getAuthServer();
        UpdateAccountResponse response = authServer.completePasswordReset(resetToken, newPassword, authUrl);
        if (!response.isValid()) {
            throw response.getError();
        }
    }

    public static RealmAsyncTask completePasswordResetAsync(final String resetToken, final String newPassword, final String authenticationUrl, Callback<Void> callback) throws ObjectServerError {
        SyncUser.checkLooperThread("Asynchronously completing a password reset is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() {
                SyncUser.completePasswordReset(resetToken, newPassword, authenticationUrl);
                return null;
            }
        }.start();
    }

    public static void requestEmailConfirmation(String email, String authenticationUrl) throws ObjectServerError {
        if (Util.isEmptyString(email)) {
            throw new IllegalArgumentException("Not-null 'email' required.");
        }
        URL authUrl = SyncUser.getUrl(authenticationUrl);
        RealmObjectServer authServer = SyncManager.getAuthServer();
        UpdateAccountResponse response = authServer.requestEmailConfirmation(email, authUrl);
        if (!response.isValid()) {
            throw response.getError();
        }
    }

    public static RealmAsyncTask requestEmailConfirmationAsync(final String email, final String authenticationUrl, Callback<Void> callback) {
        SyncUser.checkLooperThread("Asynchronously requesting an email confirmation is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() {
                SyncUser.requestEmailConfirmation(email, authenticationUrl);
                return null;
            }
        }.start();
    }

    public static void confirmEmail(String confirmationToken, String authenticationUrl) throws ObjectServerError {
        if (Util.isEmptyString(confirmationToken)) {
            throw new IllegalArgumentException("Not-null 'confirmationToken' required.");
        }
        URL authUrl = SyncUser.getUrl(authenticationUrl);
        RealmObjectServer authServer = SyncManager.getAuthServer();
        UpdateAccountResponse response = authServer.confirmEmail(confirmationToken, authUrl);
        if (!response.isValid()) {
            throw response.getError();
        }
    }

    public static RealmAsyncTask confirmEmailAsync(final String confirmationToken, final String authenticationUrl, Callback<Void> callback) {
        SyncUser.checkLooperThread("Asynchronously confirming an email is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() {
                SyncUser.confirmEmail(confirmationToken, authenticationUrl);
                return null;
            }
        }.start();
    }

    public SyncUserInfo retrieveInfoForUser(String providerUserIdentity, String provider) throws ObjectServerError {
        if (Util.isEmptyString(providerUserIdentity)) {
            throw new IllegalArgumentException("'providerUserIdentity' cannot be empty.");
        }
        if (Util.isEmptyString(provider)) {
            throw new IllegalArgumentException("'provider' cannot be empty.");
        }
        if (!this.isAdmin()) {
            throw new IllegalArgumentException("SyncUser needs to be admin in order to lookup other users ID.");
        }
        RealmObjectServer authServer = SyncManager.getAuthServer();
        LookupUserIdResponse response = authServer.retrieveUser(this.refreshToken, provider, providerUserIdentity, this.getAuthenticationUrl());
        if (!response.isValid()) {
            if (response.getError().getErrorCode() == ErrorCode.UNKNOWN_ACCOUNT) {
                return null;
            }
            throw response.getError();
        }
        return SyncUserInfo.fromLookupUserIdResponse(response);
    }

    public RealmAsyncTask retrieveInfoForUserAsync(final String providerUserIdentity, final String provider, Callback<SyncUserInfo> callback) {
        SyncUser.checkLooperThread("Asynchronously retrieving user is only possible from looper threads.");
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
        return new Request<SyncUserInfo>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public SyncUserInfo run() throws ObjectServerError {
                return SyncUser.this.retrieveInfoForUser(providerUserIdentity, provider);
            }
        }.start();
    }

    private static void checkLooperThread(String errorMessage) {
        AndroidCapabilities capabilities = new AndroidCapabilities();
        capabilities.checkCanDeliverNotification(errorMessage);
    }

    public String toJson() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("authUrl", (Object)this.authenticationUrl);
            obj.put("userToken", (Object)this.refreshToken.toJson());
            return obj.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not convert SyncUser to JSON", e);
        }
    }

    public boolean isValid() {
        return this.refreshToken != null && this.refreshToken.expiresMs() > System.currentTimeMillis() && SyncManager.getUserStore().isActive(this.identity, this.authenticationUrl.toString());
    }

    public boolean isAdmin() {
        return this.refreshToken.isAdmin();
    }

    public String getIdentity() {
        return this.identity;
    }

    Token getRefreshToken() {
        return this.refreshToken;
    }

    void setRefreshToken(Token refreshToken) {
        this.refreshToken = refreshToken;
    }

    public List<SyncSession> allSessions() {
        return SyncManager.getAllSessions(this);
    }

    boolean isRealmAuthenticated(SyncConfiguration configuration) {
        Token token = this.realms.get(configuration);
        return token != null && token.expiresMs() > System.currentTimeMillis();
    }

    Token getAccessToken(SyncConfiguration configuration) {
        return this.realms.get(configuration);
    }

    void addRealm(SyncConfiguration syncConfiguration, Token accessToken) {
        this.realms.put(syncConfiguration, accessToken);
    }

    public URL getAuthenticationUrl() {
        return this.authenticationUrl;
    }

    private static String getManagementRealmUrl(URL authUrl) {
        String scheme = "realm";
        if (authUrl.getProtocol().equalsIgnoreCase("https")) {
            scheme = "realms";
        }
        try {
            return new URI(scheme, authUrl.getUserInfo(), authUrl.getHost(), authUrl.getPort(), "/~/__management", null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create URL to the management Realm", e);
        }
    }

    public List<Permission> retrieveGrantedPermissions() {
        ObjectServerError error;
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            RetrievePermissionsResponse result = server.getPermissions(this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return result.getPermissions();
            }
            error = result.getError();
        }
        catch (Throwable e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, e);
        }
        throw error;
    }

    public RealmAsyncTask retrieveGrantedPermissionsAsync(Callback<List<Permission>> callback) {
        SyncUser.checkLooperThread("Asynchronously retrieving permissions is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<List<Permission>>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public List<Permission> run() throws ObjectServerError {
                return SyncUser.this.retrieveGrantedPermissions();
            }
        }.start();
    }

    public void applyPermissions(PermissionRequest request) {
        ObjectServerError error;
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            ApplyPermissionsResponse result = server.applyPermissions(request, this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return;
            }
            error = result.getError();
        }
        catch (Exception e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, (Throwable)e);
        }
        throw error;
    }

    public RealmAsyncTask applyPermissionsAsync(final PermissionRequest request, Callback<Void> callback) {
        SyncUser.checkLooperThread("Asynchronously updating  permissions is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() throws ObjectServerError {
                SyncUser.this.applyPermissions(request);
                return null;
            }
        }.start();
    }

    public String makePermissionsOffer(PermissionOffer offer) {
        ObjectServerError error;
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            MakePermissionsOfferResponse result = server.makeOffer(offer, this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return result.getToken();
            }
            error = result.getError();
        }
        catch (Exception e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, (Throwable)e);
        }
        throw error;
    }

    public RealmAsyncTask makePermissionsOfferAsync(final PermissionOffer offer, Callback<String> callback) {
        SyncUser.checkLooperThread("Asynchronously making an offer is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<String>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public String run() throws ObjectServerError {
                return SyncUser.this.makePermissionsOffer(offer);
            }
        }.start();
    }

    public String acceptPermissionsOffer(String offerToken) {
        ObjectServerError error;
        if (Util.isEmptyString(offerToken)) {
            throw new IllegalArgumentException("Non-empty 'offerToken' required.");
        }
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            AcceptPermissionsOfferResponse result = server.acceptOffer(offerToken, this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return result.getPath();
            }
            error = result.getError();
        }
        catch (Exception e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, (Throwable)e);
        }
        throw error;
    }

    public RealmAsyncTask acceptPermissionsOfferAsync(final String offerToken, Callback<String> callback) {
        SyncUser.checkLooperThread("Asynchronously accepting an permissions offer is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<String>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public String run() throws ObjectServerError {
                return SyncUser.this.acceptPermissionsOffer(offerToken);
            }
        }.start();
    }

    public void invalidatePermissionsOffer(String offerToken) {
        ObjectServerError error;
        if (Util.isEmptyString(offerToken)) {
            throw new IllegalArgumentException("Non-empty 'offerToken' required.");
        }
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            InvalidatePermissionsOfferResponse result = server.invalidateOffer(offerToken, this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return;
            }
            error = result.getError();
        }
        catch (Exception e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, (Throwable)e);
        }
        throw error;
    }

    public RealmAsyncTask invalidatePermissionsOfferAsync(final String offerToken, Callback<Void> callback) {
        SyncUser.checkLooperThread("Asynchronously accepting an permissions offer is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<Void>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public Void run() throws ObjectServerError {
                SyncUser.this.invalidatePermissionsOffer(offerToken);
                return null;
            }
        }.start();
    }

    public List<PermissionOffer> retrieveCreatedPermissionsOffers() {
        ObjectServerError error;
        try {
            RealmObjectServer server = SyncManager.getAuthServer();
            GetPermissionsOffersResponse result = server.getPermissionOffers(this.refreshToken, this.baseUrl);
            if (result.isValid()) {
                return result.getOffers();
            }
            error = result.getError();
        }
        catch (Exception e) {
            throw new ObjectServerError(ErrorCode.UNKNOWN, (Throwable)e);
        }
        throw error;
    }

    public RealmAsyncTask retrieveCreatedPermissionsOffersAsync(Callback<List<PermissionOffer>> callback) {
        SyncUser.checkLooperThread("Asynchronously getting all permission offers is only possible from looper threads.");
        this.checkCallbackNotNull(callback);
        return new Request<List<PermissionOffer>>(SyncManager.NETWORK_POOL_EXECUTOR, callback){

            @Override
            public List<PermissionOffer> run() throws ObjectServerError {
                return SyncUser.this.retrieveCreatedPermissionsOffers();
            }
        }.start();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncUser syncUser = (SyncUser)o;
        if (!this.identity.equals(syncUser.identity)) {
            return false;
        }
        return this.authenticationUrl.toExternalForm().equals(syncUser.authenticationUrl.toExternalForm());
    }

    public int hashCode() {
        int result = this.identity.hashCode();
        result = 31 * result + this.authenticationUrl.toExternalForm().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("UserId: ").append(this.identity);
        sb.append(", AuthUrl: ").append(this.getAuthenticationUrl());
        sb.append("}");
        return sb.toString();
    }

    private void checkCallbackNotNull(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Non-null 'callback' required.");
        }
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onError(ObjectServerError var1);
    }

    private static abstract class Request<T> {
        @Nullable
        private final Callback<T> callback;
        private final RealmNotifier handler;
        private final ThreadPoolExecutor networkPoolExecutor;

        Request(ThreadPoolExecutor networkPoolExecutor, @Nullable Callback<T> callback) {
            this.callback = callback;
            this.handler = new AndroidRealmNotifier(null, new AndroidCapabilities());
            this.networkPoolExecutor = networkPoolExecutor;
        }

        public abstract T run() throws ObjectServerError;

        public RealmAsyncTask start() {
            Future<?> authenticateRequest = this.networkPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.postSuccess(this.run());
                    }
                    catch (ObjectServerError e) {
                        this.postError(e);
                    }
                    catch (Throwable e) {
                        this.postError(new ObjectServerError(ErrorCode.UNKNOWN, "Unexpected error", e));
                    }
                }
            });
            return new RealmAsyncTaskImpl(authenticateRequest, this.networkPoolExecutor);
        }

        private void postError(final ObjectServerError error) {
            boolean errorHandled = false;
            if (this.callback != null) {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                };
                errorHandled = this.handler.post(action);
            }
            if (!errorHandled) {
                RealmLog.error(error, "An error was thrown, but could not be handled.", new Object[0]);
            }
        }

        private void postSuccess(final T result) {
            if (this.callback != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess(result);
                    }
                });
            }
        }
    }
}

