/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmModel;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.RealmProxyMediator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ColumnIndices {
    private final Map<Class<? extends RealmModel>, ColumnInfo> classToColumnInfoMap = new HashMap<Class<? extends RealmModel>, ColumnInfo>();
    private final Map<String, ColumnInfo> simpleClassNameToColumnInfoMap = new HashMap<String, ColumnInfo>();
    private final RealmProxyMediator mediator;
    private final OsSchemaInfo osSchemaInfo;

    public ColumnIndices(RealmProxyMediator mediator, OsSchemaInfo osSchemaInfo) {
        this.mediator = mediator;
        this.osSchemaInfo = osSchemaInfo;
    }

    @Nonnull
    public ColumnInfo getColumnInfo(Class<? extends RealmModel> clazz) {
        ColumnInfo columnInfo = this.classToColumnInfoMap.get(clazz);
        if (columnInfo == null) {
            columnInfo = this.mediator.createColumnInfo(clazz, this.osSchemaInfo);
            this.classToColumnInfoMap.put(clazz, columnInfo);
        }
        return columnInfo;
    }

    @Nonnull
    public ColumnInfo getColumnInfo(String simpleClassName) {
        ColumnInfo columnInfo = this.simpleClassNameToColumnInfoMap.get(simpleClassName);
        if (columnInfo == null) {
            Set<Class<? extends RealmModel>> modelClasses = this.mediator.getModelClasses();
            for (Class<? extends RealmModel> modelClass : modelClasses) {
                if (!this.mediator.getSimpleClassName(modelClass).equals(simpleClassName)) continue;
                columnInfo = this.getColumnInfo(modelClass);
                this.simpleClassNameToColumnInfoMap.put(simpleClassName, columnInfo);
                break;
            }
        }
        if (columnInfo == null) {
            throw new RealmException(String.format(Locale.US, "'%s' doesn't exist in current schema.", simpleClassName));
        }
        return columnInfo;
    }

    public void refresh() {
        for (Map.Entry<Class<? extends RealmModel>, ColumnInfo> entry : this.classToColumnInfoMap.entrySet()) {
            ColumnInfo newColumnInfo = this.mediator.createColumnInfo(entry.getKey(), this.osSchemaInfo);
            entry.getValue().copyFrom(newColumnInfo);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ColumnIndices[");
        boolean commaNeeded = false;
        for (Map.Entry<Class<? extends RealmModel>, ColumnInfo> entry : this.classToColumnInfoMap.entrySet()) {
            if (commaNeeded) {
                buf.append(",");
            }
            buf.append(entry.getKey().getSimpleName()).append("->").append(entry.getValue());
            commaNeeded = true;
        }
        return buf.append("]").toString();
    }
}

