/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmChangeListener;
import io.realm.internal.EmptyLoadChangeSet;
import io.realm.internal.ObservableCollection;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.OsResults;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.core.DescriptorOrdering;
import io.realm.internal.sync.OsSubscription;
import io.realm.internal.sync.SubscriptionAction;

public class SubscriptionAwareOsResults
extends OsResults {
    private long delayedNotificationPtr = 0L;
    private boolean subscriptionChanged;
    private OsSubscription subscription = null;
    private boolean collectionChanged = false;
    private boolean firstCallback = true;

    public static SubscriptionAwareOsResults createFromQuery(OsSharedRealm sharedRealm, TableQuery query, DescriptorOrdering queryDescriptors, SubscriptionAction subscriptionInfo) {
        query.validateQuery();
        long ptr = SubscriptionAwareOsResults.nativeCreateResults(sharedRealm.getNativePtr(), query.getNativePtr(), queryDescriptors.getNativePtr());
        return new SubscriptionAwareOsResults(sharedRealm, query.getTable(), ptr, subscriptionInfo);
    }

    SubscriptionAwareOsResults(OsSharedRealm sharedRealm, Table table, long nativePtr, SubscriptionAction subscriptionInfo) {
        super(sharedRealm, table, nativePtr);
        this.subscription = new OsSubscription(this, subscriptionInfo);
        this.subscription.addChangeListener(new RealmChangeListener<OsSubscription>(){

            @Override
            public void onChange(OsSubscription o) {
                SubscriptionAwareOsResults.this.subscriptionChanged = true;
            }
        });
        RealmNotifier notifier = sharedRealm.realmNotifier;
        notifier.addBeginSendingNotificationsCallback(new Runnable(){

            @Override
            public void run() {
                SubscriptionAwareOsResults.this.subscriptionChanged = false;
                SubscriptionAwareOsResults.this.collectionChanged = false;
                SubscriptionAwareOsResults.this.delayedNotificationPtr = 0L;
            }
        });
        notifier.addFinishedSendingNotificationsCallback(new Runnable(){

            @Override
            public void run() {
                if (SubscriptionAwareOsResults.this.collectionChanged || SubscriptionAwareOsResults.this.subscriptionChanged) {
                    SubscriptionAwareOsResults.this.triggerDelayedChangeListener();
                }
            }
        });
    }

    private void triggerDelayedChangeListener() {
        OsSubscription subscription;
        OsSubscription osSubscription = subscription = this.subscriptionChanged ? this.subscription : null;
        if (this.delayedNotificationPtr == 0L && subscription != null && !this.firstCallback && subscription.getState() != OsSubscription.SubscriptionState.ERROR && subscription.getState() != OsSubscription.SubscriptionState.COMPLETE) {
            return;
        }
        OsCollectionChangeSet changeset = this.delayedNotificationPtr == 0L ? new EmptyLoadChangeSet(subscription, this.firstCallback, true) : new OsCollectionChangeSet(this.delayedNotificationPtr, this.firstCallback, subscription, true);
        if (((OsCollectionChangeSet)changeset).isEmpty() && this.isLoaded()) {
            return;
        }
        this.loaded = true;
        this.firstCallback = false;
        this.observerPairs.foreach(new ObservableCollection.Callback(changeset));
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        this.collectionChanged = true;
        this.delayedNotificationPtr = nativeChangeSetPtr;
    }
}

