/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmResults;
import io.realm.SyncConfiguration;
import io.realm.SyncManager;
import io.realm.SyncSession;
import io.realm.SyncUser;
import io.realm.exceptions.DownloadingRealmInterruptedException;
import io.realm.exceptions.RealmException;
import io.realm.internal.Keep;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.android.AndroidCapabilities;
import io.realm.internal.network.NetworkStateReceiver;
import io.realm.internal.objectstore.OsAsyncOpenTask;
import io.realm.internal.sync.permissions.ObjectPermissionsModule;
import io.realm.sync.Subscription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Keep
public class SyncObjectServerFacade
extends ObjectServerFacade {
    private static final String WRONG_TYPE_OF_CONFIGURATION = "'configuration' has to be an instance of 'SyncConfiguration'.";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context applicationContext;
    private static volatile Method removeSessionMethod;

    @Override
    public void initialize(Context context, String userAgent) {
        try {
            Class<?> syncManager = Class.forName("io.realm.ObjectServer");
            Method method = syncManager.getDeclaredMethod("init", Context.class, String.class);
            method.setAccessible(true);
            method.invoke(null, context, userAgent);
        }
        catch (NoSuchMethodException e) {
            throw new RealmException("Could not initialize the Realm Object Server", e);
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not initialize the Realm Object Server", e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not initialize the Realm Object Server", e);
        }
        catch (ClassNotFoundException e) {
            throw new RealmException("Could not initialize the Realm Object Server", e);
        }
        if (applicationContext == null) {
            applicationContext = context;
            applicationContext.registerReceiver((BroadcastReceiver)new NetworkStateReceiver(), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    @Override
    public void realmClosed(RealmConfiguration configuration) {
        if (!(configuration instanceof SyncConfiguration)) {
            throw new IllegalArgumentException(WRONG_TYPE_OF_CONFIGURATION);
        }
        SyncConfiguration syncConfig = (SyncConfiguration)configuration;
        this.invokeRemoveSession(syncConfig);
    }

    @Override
    public Object[] getSyncConfigurationOptions(RealmConfiguration config) {
        if (config instanceof SyncConfiguration) {
            SyncConfiguration syncConfig = (SyncConfiguration)config;
            SyncUser user = syncConfig.getUser();
            String rosServerUrl = syncConfig.getServerUrl().toString();
            String rosUserIdentity = user.getIdentity();
            String syncRealmAuthUrl = user.getAuthenticationUrl().toString();
            String rosSerializedUser = user.toJson();
            byte sessionStopPolicy = syncConfig.getSessionStopPolicy().getNativeValue();
            String urlPrefix = syncConfig.getUrlPrefix();
            String customAuthorizationHeaderName = SyncManager.getAuthorizationHeaderName(syncConfig.getServerUrl());
            Map<String, String> customHeaders = SyncManager.getCustomRequestHeaders(syncConfig.getServerUrl());
            return new Object[]{rosUserIdentity, rosServerUrl, syncRealmAuthUrl, rosSerializedUser, syncConfig.syncClientValidateSsl(), syncConfig.getServerCertificateFilePath(), sessionStopPolicy, !syncConfig.isFullySynchronizedRealm(), urlPrefix, customAuthorizationHeaderName, customHeaders, syncConfig.getClientResyncMode().getNativeValue()};
        }
        return new Object[12];
    }

    public static Context getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void wrapObjectStoreSessionIfRequired(OsRealmConfig config) {
        if (config.getRealmConfiguration() instanceof SyncConfiguration) {
            SyncManager.getOrCreateSession((SyncConfiguration)config.getRealmConfiguration(), config.getResolvedRealmURI());
        }
    }

    @Override
    public String getSyncServerCertificateAssetName(RealmConfiguration configuration) {
        if (configuration instanceof SyncConfiguration) {
            SyncConfiguration syncConfig = (SyncConfiguration)configuration;
            return syncConfig.getServerCertificateAssetName();
        }
        throw new IllegalArgumentException(WRONG_TYPE_OF_CONFIGURATION);
    }

    @Override
    public String getSyncServerCertificateFilePath(RealmConfiguration configuration) {
        if (configuration instanceof SyncConfiguration) {
            SyncConfiguration syncConfig = (SyncConfiguration)configuration;
            return syncConfig.getServerCertificateFilePath();
        }
        throw new IllegalArgumentException(WRONG_TYPE_OF_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void invokeRemoveSession(SyncConfiguration syncConfig) {
        try {
            if (removeSessionMethod == null) {
                Class<SyncObjectServerFacade> clazz = SyncObjectServerFacade.class;
                // MONITORENTER : io.realm.internal.SyncObjectServerFacade.class
                if (removeSessionMethod == null) {
                    Method removeSession = SyncManager.class.getDeclaredMethod("removeSession", SyncConfiguration.class);
                    removeSession.setAccessible(true);
                    removeSessionMethod = removeSession;
                }
                // MONITOREXIT : clazz
            }
            removeSessionMethod.invoke(null, syncConfig);
            return;
        }
        catch (NoSuchMethodException e) {
            throw new RealmException("Could not lookup method to remove session: " + syncConfig.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not invoke method to remove session: " + syncConfig.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not remove session: " + syncConfig.toString(), e);
        }
    }

    @Override
    public void downloadInitialRemoteChanges(RealmConfiguration config) {
        SyncConfiguration syncConfig;
        if (config instanceof SyncConfiguration && (syncConfig = (SyncConfiguration)config).shouldWaitForInitialRemoteData()) {
            if (new AndroidCapabilities().isMainThread()) {
                throw new IllegalStateException("waitForInitialRemoteData() cannot be used synchronously on the main thread. Use Realm.getInstanceAsync() instead.");
            }
            if (syncConfig.isFullySynchronizedRealm()) {
                this.downloadInitialFullRealm(syncConfig);
            } else {
                this.downloadInitialQueryBasedRealm(syncConfig);
            }
        }
    }

    private void downloadInitialFullRealm(SyncConfiguration syncConfig) {
        OsAsyncOpenTask task = new OsAsyncOpenTask(new OsRealmConfig.Builder(syncConfig).build());
        try {
            task.start(syncConfig.getInitialRemoteDataTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new DownloadingRealmInterruptedException(syncConfig, (Throwable)e);
        }
    }

    private void downloadInitialQueryBasedRealm(SyncConfiguration syncConfig) {
        if (syncConfig.shouldWaitForInitialRemoteData()) {
            SyncSession session = SyncManager.getSession(syncConfig);
            try {
                long timeoutMillis = syncConfig.getInitialRemoteDataTimeout(TimeUnit.MILLISECONDS);
                if (!syncConfig.isFullySynchronizedRealm() && !session.uploadAllLocalChanges(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    throw new DownloadingRealmInterruptedException(syncConfig, "Failed to first upload local changes in " + timeoutMillis + " milliseconds");
                }
                if (!session.downloadAllServerChanges(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    throw new DownloadingRealmInterruptedException(syncConfig, "Failed to download remote changes in " + timeoutMillis + " milliseconds");
                }
            }
            catch (InterruptedException e) {
                throw new DownloadingRealmInterruptedException(syncConfig, (Throwable)e);
            }
        }
    }

    @Override
    public boolean wasDownloadInterrupted(Throwable throwable) {
        return throwable instanceof DownloadingRealmInterruptedException;
    }

    @Override
    public boolean isPartialRealm(RealmConfiguration configuration) {
        if (configuration instanceof SyncConfiguration) {
            SyncConfiguration syncConfig = (SyncConfiguration)configuration;
            return !syncConfig.isFullySynchronizedRealm();
        }
        return false;
    }

    @Override
    public void addSupportForObjectLevelPermissions(RealmConfiguration.Builder builder) {
        builder.addModule(new ObjectPermissionsModule());
    }

    @Override
    public void downloadInitialSubscriptions(Realm realm) {
        SyncConfiguration syncConfig;
        if (this.isPartialRealm(realm.getConfiguration()) && (syncConfig = (SyncConfiguration)realm.getConfiguration()).shouldWaitForInitialRemoteData()) {
            RealmResults<Subscription> pendingSubscriptions = realm.where(Subscription.class).equalTo("status", Subscription.State.PENDING.getValue()).findAll();
            SyncSession session = SyncManager.getSession(syncConfig);
            while (!pendingSubscriptions.isEmpty()) {
                try {
                    session.uploadAllLocalChanges();
                    session.downloadAllServerChanges();
                }
                catch (InterruptedException e) {
                    throw new DownloadingRealmInterruptedException(syncConfig, (Throwable)e);
                }
                realm.refresh();
            }
            RealmResults<Subscription> failedSubscriptions = realm.where(Subscription.class).equalTo("status", Subscription.State.ERROR.getValue()).findAll();
            if (!failedSubscriptions.isEmpty()) {
                String errorMessage = "Some initial subscriptions encountered errors:" + Arrays.toString(failedSubscriptions.toArray());
                throw new DownloadingRealmInterruptedException(syncConfig, errorMessage);
            }
        }
    }

    @Override
    public void createNativeSyncSession(RealmConfiguration configuration) {
        if (configuration instanceof SyncConfiguration) {
            SyncConfiguration syncConfig = (SyncConfiguration)configuration;
            OsRealmConfig config = new OsRealmConfig.Builder(syncConfig).build();
            SyncManager.getOrCreateSession(syncConfig, config.getResolvedRealmURI());
        }
    }
}

