/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Case;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.Table;
import java.util.Date;
import javax.annotation.Nullable;

public class TableQuery
implements NativeObject {
    private static final boolean DEBUG = false;
    private static final long nativeFinalizerPtr = TableQuery.nativeGetFinalizerPtr();
    private final NativeContext context;
    private final Table table;
    private final long nativePtr;
    private boolean queryValidated = true;
    private static final String DATE_NULL_ERROR_MESSAGE = "Date value in query criteria must not be null.";

    public TableQuery(NativeContext context, Table table, long nativeQueryPtr) {
        this.context = context;
        this.table = table;
        this.nativePtr = nativeQueryPtr;
        context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Table getTable() {
        return this.table;
    }

    void validateQuery() {
        if (!this.queryValidated) {
            String invalidMessage = this.nativeValidateQuery(this.nativePtr);
            if (invalidMessage.equals("")) {
                this.queryValidated = true;
            } else {
                throw new UnsupportedOperationException(invalidMessage);
            }
        }
    }

    public TableQuery group() {
        this.nativeGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endGroup() {
        this.nativeEndGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery or() {
        this.nativeOr(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery not() {
        this.nativeNot(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, long[] tablePtrs, long value) {
        this.nativeEqual(this.nativePtr, columnIndexes, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, long value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, long[] tablePtrs, long value) {
        this.nativeGreater(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, long[] tablePtrs, long value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, long[] tablePtrs, long value) {
        this.nativeLess(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, long[] tablePtrs, long value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, long value1, long value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeGreater(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeLess(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, long[] tablePtrs, float value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, float value1, float value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeGreater(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeGreaterEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeLess(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, long[] tablePtrs, double value) {
        this.nativeLessEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, double value1, double value2) {
        this.nativeBetween(this.nativePtr, columnIndex, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, long[] tablePtrs, boolean value) {
        this.nativeEqual(this.nativePtr, columnIndex, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndex, long[] tablePtrs, @Nullable Date value) {
        if (value == null) {
            this.nativeIsNull(this.nativePtr, columnIndex, tablePtrs);
        } else {
            this.nativeEqualTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        }
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqualTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnIndex, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnIndex, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterEqualTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnIndex, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnIndex, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessEqualTimestamp(this.nativePtr, columnIndex, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnIndex, Date value1, Date value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Date values in query criteria must not be null.");
        }
        this.nativeBetweenTimestamp(this.nativePtr, columnIndex, value1.getTime(), value2.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndices, long[] tablePtrs, byte[] value) {
        this.nativeEqual(this.nativePtr, columnIndices, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndices, long[] tablePtrs, byte[] value) {
        this.nativeNotEqual(this.nativePtr, columnIndices, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, long[] tablePtrs, @Nullable String value, Case caseSensitive) {
        this.nativeEqual(this.nativePtr, columnIndexes, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnIndexes, long[] tablePtrs, String value) {
        this.nativeEqual(this.nativePtr, columnIndexes, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, @Nullable String value, Case caseSensitive) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, @Nullable String value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnIndices, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeBeginsWith(this.nativePtr, columnIndices, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnIndices, long[] tablePtrs, String value) {
        this.nativeBeginsWith(this.nativePtr, columnIndices, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnIndices, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeEndsWith(this.nativePtr, columnIndices, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnIndices, long[] tablePtrs, String value) {
        this.nativeEndsWith(this.nativePtr, columnIndices, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery like(long[] columnIndices, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeLike(this.nativePtr, columnIndices, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery like(long[] columnIndices, long[] tablePtrs, String value) {
        this.nativeLike(this.nativePtr, columnIndices, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnIndices, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeContains(this.nativePtr, columnIndices, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnIndices, long[] tablePtrs, String value) {
        this.nativeContains(this.nativePtr, columnIndices, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isEmpty(long[] columnIndices, long[] tablePtrs) {
        this.nativeIsEmpty(this.nativePtr, columnIndices, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotEmpty(long[] columnIndices, long[] tablePtrs) {
        this.nativeIsNotEmpty(this.nativePtr, columnIndices, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    @Deprecated
    public long find(long fromTableRow) {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, fromTableRow);
    }

    public long find() {
        this.validateQuery();
        return this.nativeFind(this.nativePtr, 0L);
    }

    public long sumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public long sumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Long maximumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public Long maximumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Long minimumInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public Long minimumInt(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageInt(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageInt(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double sumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Float maximumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public Float maximumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Float minimumFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public Float minimumFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageFloat(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageFloat(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double sumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double sumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Double maximumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public Double maximumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Double minimumDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public Double minimumDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public double averageDouble(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, start, end, limit);
    }

    public double averageDouble(long columnIndex) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnIndex, 0L, -1L, -1L);
    }

    public Date maximumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        Long result = this.nativeMaximumTimestamp(this.nativePtr, columnIndex, start, end, limit);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Date maximumDate(long columnIndex) {
        this.validateQuery();
        Long result = this.nativeMaximumTimestamp(this.nativePtr, columnIndex, 0L, -1L, -1L);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Date minimumDate(long columnIndex, long start, long end, long limit) {
        this.validateQuery();
        Long result = this.nativeMinimumTimestamp(this.nativePtr, columnIndex, start, end, limit);
        if (result != null) {
            return new Date(result * 1000L);
        }
        return null;
    }

    public Date minimumDate(long columnIndex) {
        this.validateQuery();
        Long result = this.nativeMinimumTimestamp(this.nativePtr, columnIndex, 0L, -1L, -1L);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public TableQuery isNull(long[] columnIndices, long[] tablePtrs) {
        this.nativeIsNull(this.nativePtr, columnIndices, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotNull(long[] columnIndices, long[] tablePtrs) {
        this.nativeIsNotNull(this.nativePtr, columnIndices, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public long count(long start, long end, long limit) {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, start, end, limit);
    }

    @Deprecated
    public long count() {
        this.validateQuery();
        return this.nativeCount(this.nativePtr, 0L, -1L, -1L);
    }

    public long remove() {
        this.validateQuery();
        if (this.table.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr);
    }

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }

    public void alwaysTrue() {
        this.nativeAlwaysTrue(this.nativePtr);
    }

    public void alwaysFalse() {
        this.nativeAlwaysFalse(this.nativePtr);
    }

    private native String nativeValidateQuery(long var1);

    private native void nativeGroup(long var1);

    private native void nativeEndGroup(long var1);

    private native void nativeOr(long var1);

    private native void nativeNot(long var1);

    private native void nativeEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeBetween(long var1, long[] var3, long var4, long var6);

    private native void nativeEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, float var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, float var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeBetween(long var1, long[] var3, float var4, float var5);

    private native void nativeEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, double var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, double var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeBetween(long var1, long[] var3, double var4, double var6);

    private native void nativeEqual(long var1, long[] var3, long[] var4, boolean var5);

    private native void nativeEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeNotEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeBetweenTimestamp(long var1, long[] var3, long var4, long var6);

    private native void nativeEqual(long var1, long[] var3, long[] var4, byte[] var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, byte[] var5);

    private native void nativeEqual(long var1, long[] var3, long[] var4, @Nullable String var5, boolean var6);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, @Nullable String var5, boolean var6);

    private native void nativeBeginsWith(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeEndsWith(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeLike(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeContains(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeIsEmpty(long var1, long[] var3, long[] var4);

    private native void nativeIsNotEmpty(long var1, long[] var3, long[] var4);

    private native void nativeAlwaysTrue(long var1);

    private native void nativeAlwaysFalse(long var1);

    private native long nativeFind(long var1, long var3);

    private native long nativeFindAll(long var1, long var3, long var5, long var7);

    private native long nativeSumInt(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMaximumInt(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMinimumInt(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageInt(long var1, long var3, long var5, long var7, long var9);

    private native double nativeSumFloat(long var1, long var3, long var5, long var7, long var9);

    private native Float nativeMaximumFloat(long var1, long var3, long var5, long var7, long var9);

    private native Float nativeMinimumFloat(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageFloat(long var1, long var3, long var5, long var7, long var9);

    private native double nativeSumDouble(long var1, long var3, long var5, long var7, long var9);

    private native Double nativeMaximumDouble(long var1, long var3, long var5, long var7, long var9);

    private native Double nativeMinimumDouble(long var1, long var3, long var5, long var7, long var9);

    private native double nativeAverageDouble(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMaximumTimestamp(long var1, long var3, long var5, long var7, long var9);

    private native Long nativeMinimumTimestamp(long var1, long var3, long var5, long var7, long var9);

    private native void nativeIsNull(long var1, long[] var3, long[] var4);

    private native void nativeIsNotNull(long var1, long[] var3, long[] var4);

    private native long nativeCount(long var1, long var3, long var5, long var7);

    private native long nativeRemove(long var1);

    private static native long nativeGetFinalizerPtr();
}

