/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.CheckedRow;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsList;
import io.realm.internal.Row;
import io.realm.internal.Table;
import java.util.Date;
import javax.annotation.Nullable;

public class UncheckedRow
implements NativeObject,
Row {
    private static final long nativeFinalizerPtr = UncheckedRow.nativeGetFinalizerPtr();
    private final NativeContext context;
    private final Table parent;
    private final long nativePtr;

    public UncheckedRow(NativeContext context, Table parent, long nativePtr) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePtr;
        context.addReference(this);
    }

    UncheckedRow(UncheckedRow row) {
        this.context = row.context;
        this.parent = row.parent;
        this.nativePtr = row.nativePtr;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    static UncheckedRow getByRowIndex(NativeContext context, Table table, long index) {
        long nativeRowPointer = table.nativeGetRowPtr(table.getNativePtr(), index);
        return new UncheckedRow(context, table, nativeRowPointer);
    }

    static UncheckedRow getByRowPointer(NativeContext context, Table table, long nativeRowPointer) {
        return new UncheckedRow(context, table, nativeRowPointer);
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    @Override
    public Table getTable() {
        return this.parent;
    }

    @Override
    public long getIndex() {
        return this.nativeGetIndex(this.nativePtr);
    }

    @Override
    public long getLong(long columnIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex);
    }

    @Override
    public boolean getBoolean(long columnIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex);
    }

    @Override
    public float getFloat(long columnIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex);
    }

    @Override
    public double getDouble(long columnIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex);
    }

    @Override
    public Date getDate(long columnIndex) {
        return new Date(this.nativeGetTimestamp(this.nativePtr, columnIndex));
    }

    @Override
    public String getString(long columnIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex);
    }

    @Override
    public byte[] getBinaryByteArray(long columnIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex);
    }

    @Override
    public long getLink(long columnIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex);
    }

    @Override
    public boolean isNullLink(long columnIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex);
    }

    @Override
    public OsList getModelList(long columnIndex) {
        return new OsList(this, columnIndex);
    }

    @Override
    public OsList getValueList(long columnIndex, RealmFieldType fieldType) {
        return new OsList(this, columnIndex);
    }

    @Override
    public void setLong(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.nativeSetLong(this.nativePtr, columnIndex, value);
    }

    @Override
    public void setBoolean(long columnIndex, boolean value) {
        this.parent.checkImmutable();
        this.nativeSetBoolean(this.nativePtr, columnIndex, value);
    }

    @Override
    public void setFloat(long columnIndex, float value) {
        this.parent.checkImmutable();
        this.nativeSetFloat(this.nativePtr, columnIndex, value);
    }

    @Override
    public void setDouble(long columnIndex, double value) {
        this.parent.checkImmutable();
        this.nativeSetDouble(this.nativePtr, columnIndex, value);
    }

    @Override
    public void setDate(long columnIndex, Date date) {
        this.parent.checkImmutable();
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        long timestamp = date.getTime();
        this.nativeSetTimestamp(this.nativePtr, columnIndex, timestamp);
    }

    @Override
    public void setString(long columnIndex, @Nullable String value) {
        this.parent.checkImmutable();
        if (value == null) {
            this.nativeSetNull(this.nativePtr, columnIndex);
        } else {
            this.nativeSetString(this.nativePtr, columnIndex, value);
        }
    }

    @Override
    public void setBinaryByteArray(long columnIndex, @Nullable byte[] data) {
        this.parent.checkImmutable();
        this.nativeSetByteArray(this.nativePtr, columnIndex, data);
    }

    @Override
    public void setLink(long columnIndex, long value) {
        this.parent.checkImmutable();
        this.nativeSetLink(this.nativePtr, columnIndex, value);
    }

    @Override
    public void nullifyLink(long columnIndex) {
        this.parent.checkImmutable();
        this.nativeNullifyLink(this.nativePtr, columnIndex);
    }

    @Override
    public boolean isNull(long columnIndex) {
        return this.nativeIsNull(this.nativePtr, columnIndex);
    }

    @Override
    public void setNull(long columnIndex) {
        this.parent.checkImmutable();
        this.nativeSetNull(this.nativePtr, columnIndex);
    }

    public CheckedRow convertToChecked() {
        return CheckedRow.getFromRow(this);
    }

    @Override
    public boolean isAttached() {
        return this.nativePtr != 0L && this.nativeIsAttached(this.nativePtr);
    }

    @Override
    public void checkIfAttached() {
        if (!this.isAttached()) {
            throw new IllegalStateException("Object is no longer managed by Realm. Has it been deleted?");
        }
    }

    @Override
    public boolean hasColumn(String fieldName) {
        return this.nativeHasColumn(this.nativePtr, fieldName);
    }

    protected native long nativeGetColumnCount(long var1);

    protected native String nativeGetColumnName(long var1, long var3);

    protected native long nativeGetColumnIndex(long var1, String var3);

    protected native int nativeGetColumnType(long var1, long var3);

    protected native long nativeGetIndex(long var1);

    protected native long nativeGetLong(long var1, long var3);

    protected native boolean nativeGetBoolean(long var1, long var3);

    protected native float nativeGetFloat(long var1, long var3);

    protected native double nativeGetDouble(long var1, long var3);

    protected native long nativeGetTimestamp(long var1, long var3);

    protected native String nativeGetString(long var1, long var3);

    protected native boolean nativeIsNullLink(long var1, long var3);

    protected native byte[] nativeGetByteArray(long var1, long var3);

    protected native void nativeSetLong(long var1, long var3, long var5);

    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    protected native void nativeSetFloat(long var1, long var3, float var5);

    protected native long nativeGetLink(long var1, long var3);

    protected native void nativeSetDouble(long var1, long var3, double var5);

    protected native void nativeSetTimestamp(long var1, long var3, long var5);

    protected native void nativeSetString(long var1, long var3, String var5);

    protected native void nativeSetByteArray(long var1, long var3, @Nullable byte[] var5);

    protected native void nativeSetLink(long var1, long var3, long var5);

    protected native void nativeNullifyLink(long var1, long var3);

    protected native boolean nativeIsAttached(long var1);

    protected native boolean nativeHasColumn(long var1, String var3);

    protected native boolean nativeIsNull(long var1, long var3);

    protected native void nativeSetNull(long var1, long var3);

    private static native long nativeGetFinalizerPtr();
}

