/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import android.os.Build;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.log.RealmLog;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

public class Util {
    public static String getTablePrefix() {
        return Util.nativeGetTablePrefix();
    }

    static native String nativeGetTablePrefix();

    public static Class<? extends RealmModel> getOriginalModelClass(Class<? extends RealmModel> clazz) {
        if (clazz.equals(RealmModel.class) || clazz.equals(RealmObject.class)) {
            throw new IllegalArgumentException("RealmModel or RealmObject was passed as an argument. Only subclasses of these can be used as arguments to methods that accept a Realm model class.");
        }
        Class<? extends RealmModel> superclass = clazz.getSuperclass();
        if (!superclass.equals(Object.class) && !superclass.equals(RealmObject.class)) {
            clazz = superclass;
        }
        return clazz;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static boolean isEmptyString(@Nullable String str) {
        return str == null || str.length() == 0;
    }

    public static boolean deleteRealm(String canonicalPath, File realmFolder, String realmFileName) {
        boolean realmDeleted;
        String management = ".management";
        File managementFolder = new File(realmFolder, realmFileName + ".management");
        File realmFile = new File(canonicalPath);
        File fifoFile = new File(canonicalPath + ".note");
        File[] files = managementFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean deleteResult = file.delete();
                if (deleteResult) continue;
                RealmLog.warn(String.format(Locale.ENGLISH, "Realm temporary file at %s cannot be deleted", file.getAbsolutePath()), new Object[0]);
            }
        }
        if (managementFolder.exists() && !managementFolder.delete()) {
            RealmLog.warn(String.format(Locale.ENGLISH, "Realm temporary folder at %s cannot be deleted", managementFolder.getAbsolutePath()), new Object[0]);
        }
        if (realmFile.exists()) {
            realmDeleted = realmFile.delete();
            if (!realmDeleted) {
                RealmLog.warn(String.format(Locale.ENGLISH, "Realm file at %s cannot be deleted", realmFile.getAbsolutePath()), new Object[0]);
            }
        } else {
            realmDeleted = true;
        }
        if (fifoFile.exists() && !fifoFile.delete()) {
            RealmLog.warn(String.format(Locale.ENGLISH, ".note file at %s cannot be deleted", fifoFile.getAbsolutePath()), new Object[0]);
        }
        return realmDeleted;
    }

    public static <T> Set<T> toSet(T ... items) {
        if (items == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            if (item == null) continue;
            set.add(item);
        }
        return set;
    }
}

