/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.core;

import io.realm.internal.NativeObject;
import io.realm.internal.core.IncludeDescriptor;
import io.realm.internal.core.QueryDescriptor;

public class DescriptorOrdering
implements NativeObject {
    private static final long nativeFinalizerMethodPtr = DescriptorOrdering.nativeGetFinalizerMethodPtr();
    private final long nativePtr = DescriptorOrdering.nativeCreate();
    private boolean sortDefined = false;
    private boolean distinctDefined = false;
    private boolean limitDefined = false;

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerMethodPtr;
    }

    public void appendSort(QueryDescriptor descriptor) {
        if (this.sortDefined) {
            throw new IllegalStateException("A sorting order was already defined. It cannot be redefined");
        }
        DescriptorOrdering.nativeAppendSort(this.nativePtr, descriptor);
        this.sortDefined = true;
    }

    public void appendDistinct(QueryDescriptor descriptor) {
        if (this.distinctDefined) {
            throw new IllegalStateException("A distinct field was already defined. It cannot be redefined");
        }
        DescriptorOrdering.nativeAppendDistinct(this.nativePtr, descriptor);
        this.distinctDefined = true;
    }

    public void setLimit(long limit) {
        if (this.limitDefined) {
            throw new IllegalStateException("A limit was already set. It cannot be redefined.");
        }
        DescriptorOrdering.nativeAppendLimit(this.nativePtr, limit);
        this.limitDefined = true;
    }

    public void appendIncludes(IncludeDescriptor descriptor) {
        DescriptorOrdering.nativeAppendInclude(this.nativePtr, descriptor.getNativePtr());
    }

    public boolean isEmpty() {
        return DescriptorOrdering.nativeIsEmpty(this.nativePtr);
    }

    private static native long nativeGetFinalizerMethodPtr();

    private static native long nativeCreate();

    private static native void nativeAppendSort(long var0, QueryDescriptor var2);

    private static native void nativeAppendDistinct(long var0, QueryDescriptor var2);

    private static native void nativeAppendLimit(long var0, long var2);

    private static native void nativeAppendInclude(long var0, long var2);

    private static native boolean nativeIsEmpty(long var0);
}

