/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.core;

import io.realm.RealmFieldType;
import io.realm.internal.NativeObject;
import io.realm.internal.Table;
import io.realm.internal.fields.FieldDescriptor;
import java.util.EnumSet;

public class IncludeDescriptor
implements NativeObject {
    private static final long nativeFinalizerMethodPtr = IncludeDescriptor.nativeGetFinalizerMethodPtr();
    private final long nativePtr;

    public static IncludeDescriptor createInstance(FieldDescriptor.SchemaProxy schemaConnector, Table table, String includePath) {
        EnumSet<RealmFieldType> supportedIntermediateColumnTypes = EnumSet.of(RealmFieldType.OBJECT, RealmFieldType.LIST, RealmFieldType.LINKING_OBJECTS);
        EnumSet<RealmFieldType> supportedFinalColumnType = EnumSet.of(RealmFieldType.LINKING_OBJECTS);
        FieldDescriptor fieldDescriptor = FieldDescriptor.createFieldDescriptor(schemaConnector, table, includePath, supportedIntermediateColumnTypes, supportedFinalColumnType);
        return new IncludeDescriptor(table, fieldDescriptor.getColumnIndices(), fieldDescriptor.getNativeTablePointers());
    }

    private IncludeDescriptor(Table table, long[] columnIndices, long[] nativeTablePointers) {
        this.nativePtr = IncludeDescriptor.nativeCreate(table.getNativePtr(), columnIndices, nativeTablePointers);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerMethodPtr;
    }

    private static native long nativeGetFinalizerMethodPtr();

    private static native long nativeCreate(long var0, long[] var2, long[] var3);
}

