/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.fields;

import io.realm.RealmFieldType;
import io.realm.internal.ColumnInfo;
import io.realm.internal.Table;
import io.realm.internal.fields.CachedFieldDescriptor;
import io.realm.internal.fields.DynamicFieldDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class FieldDescriptor {
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\\.");
    public static final Set<RealmFieldType> ALL_LINK_FIELD_TYPES;
    public static final Set<RealmFieldType> SIMPLE_LINK_FIELD_TYPES;
    public static final Set<RealmFieldType> LIST_LINK_FIELD_TYPE;
    public static final Set<RealmFieldType> OBJECT_LINK_FIELD_TYPE;
    public static final Set<RealmFieldType> NO_LINK_FIELD_TYPE;
    private final List<String> fields;
    private final Set<RealmFieldType> validInternalColumnTypes;
    private final Set<RealmFieldType> validFinalColumnTypes;
    private String finalColumnName;
    private RealmFieldType finalColumnType;
    private long[] columnIndices;
    private long[] nativeTablePointers;

    public static FieldDescriptor createStandardFieldDescriptor(SchemaProxy schema, Table table, String fieldDescription, RealmFieldType ... validFinalColumnTypes) {
        return FieldDescriptor.createFieldDescriptor(schema, table, fieldDescription, null, new HashSet<RealmFieldType>(Arrays.asList(validFinalColumnTypes)));
    }

    public static FieldDescriptor createFieldDescriptor(SchemaProxy schema, Table table, String fieldDescription, Set<RealmFieldType> validInternalColumnTypes, Set<RealmFieldType> validFinalColumnTypes) {
        return schema == null || !schema.hasCache() ? new DynamicFieldDescriptor(table, fieldDescription, null != validInternalColumnTypes ? validInternalColumnTypes : SIMPLE_LINK_FIELD_TYPES, validFinalColumnTypes) : new CachedFieldDescriptor(schema, table.getClassName(), fieldDescription, null != validInternalColumnTypes ? validInternalColumnTypes : ALL_LINK_FIELD_TYPES, validFinalColumnTypes);
    }

    protected FieldDescriptor(String fieldDescription, Set<RealmFieldType> validInternalColumnTypes, Set<RealmFieldType> validFinalColumnTypes) {
        this.fields = this.parseFieldDescription(fieldDescription);
        int nFields = this.fields.size();
        if (nFields <= 0) {
            throw new IllegalArgumentException("Invalid query: Empty field descriptor");
        }
        this.validInternalColumnTypes = validInternalColumnTypes;
        this.validFinalColumnTypes = validFinalColumnTypes;
    }

    public final int length() {
        return this.fields.size();
    }

    public final long[] getColumnIndices() {
        this.compileIfNecessary();
        return Arrays.copyOf(this.columnIndices, this.columnIndices.length);
    }

    public final long[] getNativeTablePointers() {
        this.compileIfNecessary();
        return Arrays.copyOf(this.nativeTablePointers, this.nativeTablePointers.length);
    }

    public final String getFinalColumnName() {
        this.compileIfNecessary();
        return this.finalColumnName;
    }

    public final RealmFieldType getFinalColumnType() {
        this.compileIfNecessary();
        return this.finalColumnType;
    }

    protected abstract void compileFieldDescription(List<String> var1);

    protected final void verifyInternalColumnType(String tableName, String columnName, RealmFieldType columnType) {
        this.verifyColumnType(tableName, columnName, columnType, this.validInternalColumnTypes);
    }

    protected final void setCompilationResults(String finalClassName, String finalColumnName, RealmFieldType finalColumnType, long[] columnIndices, long[] nativeTablePointers) {
        if (this.validFinalColumnTypes != null && this.validFinalColumnTypes.size() > 0) {
            this.verifyColumnType(finalClassName, finalColumnName, finalColumnType, this.validFinalColumnTypes);
        }
        this.finalColumnName = finalColumnName;
        this.finalColumnType = finalColumnType;
        this.columnIndices = columnIndices;
        this.nativeTablePointers = nativeTablePointers;
    }

    private List<String> parseFieldDescription(String fieldDescription) {
        if (fieldDescription == null || fieldDescription.equals("")) {
            throw new IllegalArgumentException("Invalid query: field name is empty");
        }
        int lastDotIndex = fieldDescription.lastIndexOf(".");
        if (lastDotIndex == fieldDescription.length() - 1) {
            throw new IllegalArgumentException("Invalid query: field name must not end with a period ('.')");
        }
        if (lastDotIndex > -1) {
            return Arrays.asList(FIELD_SEPARATOR.split(fieldDescription));
        }
        return Collections.singletonList(fieldDescription);
    }

    private void verifyColumnType(String className, String columnName, RealmFieldType columnType, Set<RealmFieldType> validTypes) {
        if (!validTypes.contains((Object)columnType)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Invalid query: field '%s' in class '%s' is of invalid type '%s'.", columnName, className, columnType.toString()));
        }
    }

    private void compileIfNecessary() {
        if (this.finalColumnType == null) {
            this.compileFieldDescription(this.fields);
        }
    }

    static {
        HashSet<RealmFieldType> s = new HashSet<RealmFieldType>(3);
        s.add(RealmFieldType.OBJECT);
        s.add(RealmFieldType.LIST);
        s.add(RealmFieldType.LINKING_OBJECTS);
        ALL_LINK_FIELD_TYPES = Collections.unmodifiableSet(s);
        s = new HashSet(2);
        s.add(RealmFieldType.OBJECT);
        s.add(RealmFieldType.LIST);
        SIMPLE_LINK_FIELD_TYPES = Collections.unmodifiableSet(s);
        s = new HashSet(1);
        s.add(RealmFieldType.LIST);
        LIST_LINK_FIELD_TYPE = Collections.unmodifiableSet(s);
        s = new HashSet(1);
        s.add(RealmFieldType.OBJECT);
        OBJECT_LINK_FIELD_TYPE = Collections.unmodifiableSet(s);
        NO_LINK_FIELD_TYPE = Collections.emptySet();
    }

    public static interface SchemaProxy {
        public boolean hasCache();

        public ColumnInfo getColumnInfo(String var1);

        public long getNativeTablePtr(String var1);
    }
}

