/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import java.io.IOException;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class AcceptPermissionsOfferResponse
extends AuthServerResponse {
    private String path;

    static AcceptPermissionsOfferResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new AcceptPermissionsOfferResponse(error);
        }
        if (!response.isSuccessful()) {
            return new AcceptPermissionsOfferResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new AcceptPermissionsOfferResponse(serverResponse);
    }

    public static AcceptPermissionsOfferResponse from(ObjectServerError objectServerError) {
        return new AcceptPermissionsOfferResponse(objectServerError);
    }

    public static AcceptPermissionsOfferResponse from(Exception exception) {
        return AcceptPermissionsOfferResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private AcceptPermissionsOfferResponse(ObjectServerError error) {
        RealmLog.debug("AcceptPermissionsOffer - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private AcceptPermissionsOfferResponse(String serverResponse) {
        RealmLog.debug("AcceptPermissionsOffer - Success: %s", serverResponse);
        try {
            JSONObject obj = new JSONObject(serverResponse);
            this.path = obj.getString("path");
        }
        catch (JSONException e) {
            this.error = new ObjectServerError(ErrorCode.JSON_EXCEPTION, (Throwable)e);
        }
    }

    public String getPath() {
        return this.path;
    }
}

