/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.permissions.AccessLevel;
import io.realm.permissions.PermissionRequest;
import io.realm.permissions.UserCondition;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplyPermissionsRequest {
    private final AccessLevel level;
    private final String realmUrl;
    private final String userId;
    private final String metadataKey;
    private final String metadataValue;

    public ApplyPermissionsRequest(PermissionRequest request) {
        UserCondition condition = request.getCondition();
        this.level = request.getAccessLevel();
        this.realmUrl = request.getUrl();
        switch (condition.getType()) {
            case USER_ID: {
                this.userId = condition.getValue();
                this.metadataKey = null;
                this.metadataValue = null;
                break;
            }
            case METADATA: {
                this.userId = null;
                this.metadataKey = condition.getKey();
                this.metadataValue = condition.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)condition.getType()));
            }
        }
    }

    public String toJson() throws JSONException {
        JSONObject request = new JSONObject();
        request.put("realmPath", (Object)this.realmUrl);
        request.put("accessLevel", (Object)this.level.getKey());
        JSONObject condition = new JSONObject();
        if (this.userId != null) {
            condition.put("userId", (Object)this.userId);
        } else {
            condition.put("metadataKey", (Object)this.metadataKey);
            condition.put("metadataValue", (Object)this.metadataValue);
        }
        request.put("condition", (Object)condition);
        return request.toString();
    }
}

