/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import java.io.IOException;
import okhttp3.Response;

public class ApplyPermissionsResponse
extends AuthServerResponse {
    static ApplyPermissionsResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new ApplyPermissionsResponse(error);
        }
        if (!response.isSuccessful()) {
            return new ApplyPermissionsResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new ApplyPermissionsResponse(serverResponse);
    }

    public static ApplyPermissionsResponse from(ObjectServerError objectServerError) {
        return new ApplyPermissionsResponse(objectServerError);
    }

    public static ApplyPermissionsResponse from(Exception exception) {
        return ApplyPermissionsResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    private ApplyPermissionsResponse(ObjectServerError error) {
        RealmLog.debug("ApplyPermissions - Error: %s", error);
        this.setError(error);
        this.error = error;
    }

    private ApplyPermissionsResponse(String serverResponse) {
        RealmLog.debug("ApplyPermissions - Success: %s", serverResponse);
    }
}

