/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AuthServerResponse {
    protected ObjectServerError error;

    public boolean isValid() {
        return this.error == null;
    }

    public ObjectServerError getError() {
        return this.error;
    }

    protected void setError(ObjectServerError error) {
        this.error = error;
    }

    public static ObjectServerError createError(String response, int httpErrorCode) {
        try {
            JSONObject obj = new JSONObject(response);
            String title = obj.optString("title", null);
            String hint = obj.optString("hint", null);
            ErrorCode errorCode = obj.has("code") ? ErrorCode.fromNativeError("auth", obj.getInt("code")) : (obj.has("status") ? ErrorCode.fromNativeError("auth", obj.getInt("status")) : ErrorCode.UNKNOWN);
            return new ObjectServerError(errorCode, title, hint);
        }
        catch (JSONException e) {
            return new ObjectServerError(ErrorCode.JSON_EXCEPTION, "Server failed with " + httpErrorCode + ", but could not parse error.", e);
        }
    }
}

