/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.ObjectServerError;
import io.realm.internal.network.AuthServerResponse;
import io.realm.internal.objectserver.SyncWorker;
import io.realm.internal.objectserver.Token;
import io.realm.log.RealmLog;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticateResponse
extends AuthServerResponse {
    private static final String JSON_FIELD_ACCESS_TOKEN = "access_token";
    private static final String JSON_FIELD_REFRESH_TOKEN = "refresh_token";
    private static final String JSON_FIELD_SYNC_WORKER = "sync_worker";
    private final Token accessToken;
    private final Token refreshToken;
    private final SyncWorker syncWorker;

    public static AuthenticateResponse from(Response response) {
        String serverResponse;
        try {
            serverResponse = response.body().string();
        }
        catch (IOException e) {
            ObjectServerError error = new ObjectServerError(ErrorCode.IO_EXCEPTION, (Throwable)e);
            return new AuthenticateResponse(error);
        }
        if (!response.isSuccessful()) {
            return new AuthenticateResponse(AuthServerResponse.createError(serverResponse, response.code()));
        }
        return new AuthenticateResponse(serverResponse);
    }

    public static AuthenticateResponse from(String json) {
        return new AuthenticateResponse(json);
    }

    public static AuthenticateResponse from(ObjectServerError error) {
        return new AuthenticateResponse(error);
    }

    public static AuthenticateResponse from(Exception exception) {
        return AuthenticateResponse.from(new ObjectServerError(ErrorCode.fromException(exception), (Throwable)exception));
    }

    public static AuthenticateResponse createValidResponseWithUser(String identifier, String refreshToken, boolean isAdmin) {
        try {
            JSONObject response = new JSONObject();
            response.put(JSON_FIELD_REFRESH_TOKEN, (Object)new Token(refreshToken, identifier, null, Long.MAX_VALUE, Token.Permission.ALL, isAdmin).toJson());
            return new AuthenticateResponse(response.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private AuthenticateResponse(ObjectServerError error) {
        this.setError(error);
        this.accessToken = null;
        this.refreshToken = null;
        this.syncWorker = null;
    }

    private AuthenticateResponse(String serverResponse) {
        String debugMessage;
        ObjectServerError error;
        SyncWorker syncWorker;
        Token refreshToken;
        Token accessToken;
        try {
            JSONObject obj = new JSONObject(serverResponse);
            accessToken = obj.has(JSON_FIELD_ACCESS_TOKEN) ? Token.from(obj.getJSONObject(JSON_FIELD_ACCESS_TOKEN)) : null;
            refreshToken = obj.has(JSON_FIELD_REFRESH_TOKEN) ? Token.from(obj.getJSONObject(JSON_FIELD_REFRESH_TOKEN)) : null;
            syncWorker = obj.has(JSON_FIELD_SYNC_WORKER) ? SyncWorker.from(obj.getJSONObject(JSON_FIELD_SYNC_WORKER)) : null;
            error = null;
            debugMessage = accessToken == null ? "accessToken = null" : String.format(Locale.US, "Identity %s; Path %s", accessToken.identity(), accessToken.path());
        }
        catch (JSONException ex) {
            accessToken = null;
            refreshToken = null;
            syncWorker = null;
            String exceptionMessage = String.format(Locale.US, "Server response could not be parsed as JSON:%n%s", serverResponse);
            error = new ObjectServerError(ErrorCode.JSON_EXCEPTION, exceptionMessage, ex);
            debugMessage = String.format(Locale.US, "Error %s", error.getErrorMessage());
        }
        RealmLog.debug("AuthenticateResponse. " + debugMessage, new Object[0]);
        this.setError(error);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.syncWorker = syncWorker;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public Token getRefreshToken() {
        return this.refreshToken;
    }

    public SyncWorker getSyncWorker() {
        return this.syncWorker;
    }
}

