/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.network;

import io.realm.ErrorCode;
import io.realm.internal.network.AuthServerResponse;
import io.realm.log.RealmLog;
import java.util.concurrent.TimeUnit;

public abstract class ExponentialBackoffTask<T extends AuthServerResponse>
implements Runnable {
    private final int maxRetries;

    public ExponentialBackoffTask(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public ExponentialBackoffTask() {
        this(0x7FFFFFFE);
    }

    protected abstract T execute();

    protected boolean isSuccess(T result) {
        return result != null && ((AuthServerResponse)result).isValid();
    }

    protected boolean shouldAbortTask(T response) {
        if (Thread.interrupted()) {
            return true;
        }
        if (!((AuthServerResponse)response).isValid()) {
            return ((AuthServerResponse)response).getError().getErrorCode() != ErrorCode.IO_EXCEPTION;
        }
        return false;
    }

    protected abstract void onSuccess(T var1);

    protected abstract void onError(T var1);

    @Override
    public void run() {
        int attempt = 0;
        while (!Thread.interrupted()) {
            T response;
            long sleep;
            if ((sleep = ExponentialBackoffTask.calculateExponentialDelay(++attempt - 1, TimeUnit.MINUTES.toMillis(5L))) > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    RealmLog.debug("Incremental backoff was interrupted.", new Object[0]);
                    return;
                }
            }
            if (this.isSuccess(response = this.execute())) {
                this.onSuccess(response);
                break;
            }
            if (!this.shouldAbortTask(response) && attempt != this.maxRetries + 1) continue;
            this.onError(response);
            break;
        }
    }

    private static long calculateExponentialDelay(int failedAttempts, long maxDelayInMs) {
        double SCALE = 1.0;
        double delayInMs = (Math.pow(2.0, failedAttempts) - 1.0) / 2.0 * 1000.0 * SCALE;
        return (double)maxDelayInMs < delayInMs ? maxDelayInMs : (long)delayInMs;
    }
}

